package ru.yandex.autotests.direct.api.ads.moderate;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 17.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка прав доступа агентства к объявлению")
@Issue("https://st.yandex-team.ru/DIRECT-40261")
@RunWith(Parameterized.class)
public class AgencyCheckRightsToIdTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String client = AdsLogins.CLIENT;
    private static String agency = AdsLogins.AGENCY;
    private static String agencyRep = AdsLogins.AGENCY_REP;
    private static String agencyRepCl = AdsLogins.AGENCY_REP_CL;
    private static String subclient = AdsLogins.SUBCLIENT;
    private static String subclientElse = AdsLogins.SUBCLIENT_ELSE;

    private static Long clientAdId;
    private static Long subclientAdId;
    private static Long subclientElseAdId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency},
                {agencyRep},
                {agencyRepCl}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createNotMineCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agency);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(subclient);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclient, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientElse, ShardNumbers.DEFAULT_SHARD);
        api.as(client);
        Long clientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        Long clientAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(clientCampaignId);
        clientAdId = api.userSteps.adsSteps().addDefaultTextAd(clientAdGroupId);
        api.userSteps.keywordsSteps().addDefaultKeyword(clientAdGroupId);
        api.as(agency);
        Long subclientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        Long subclientAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(subclientCampaignId, subclient);
        subclientAdId = api.userSteps.adsSteps().addDefaultTextAd(subclientAdGroupId, subclient);
        api.userSteps.keywordsSteps().addDefaultKeyword(subclient, subclientAdGroupId);
        Long subclientElseCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclientElse);
        Long subclientElseAdGroupId =
                api.userSteps.adGroupsSteps().addDefaultGroup(subclientElseCampaignId, subclientElse);
        subclientElseAdId = api.userSteps.adsSteps().addDefaultTextAd(subclientElseAdGroupId, subclientElse);
        api.userSteps.keywordsSteps().addDefaultKeyword(subclientElse, subclientElseAdGroupId);
    }

    @Test
    public void callModerateWithSubclientId() {
        api.userSteps.bannersFakeSteps().setStatusModerate(subclientAdId, Status.NEW);
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnModerate(
                new IdsCriteriaMap().withIds(subclientAdId),
                subclient,
                ExpectedResult.success(subclientAdId)
        );
    }

    @Test
    public void callModerateWithSubclientElseId() {
        //DIRECT-41222
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnModerate(
                new IdsCriteriaMap().withIds(subclientElseAdId),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }

    @Test
    public void callModerateWithIdsOfBothSubclients() {
        //DIRECT-41222
        api.userSteps.bannersFakeSteps().setStatusModerate(subclientAdId, Status.NEW);
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnModerate(
                new IdsCriteriaMap().withIds(subclientAdId, subclientElseAdId),
                subclient,
                ExpectedResult.success(subclientAdId),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }

    @Test
    public void callModerateWithClientId() {
        api.as(loginForAuthorization).userSteps.adsSteps().shouldGetResultOnModerate(
                new IdsCriteriaMap().withIds(clientAdId),
                subclient,
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND))
        );
    }
}
