package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 30.11.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка влияния Moderate для динамического текстового объявления на статусы объектов")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
public class CheckFakeStatusesAfterModerateDynamicTextAdTest {

    //DIRECT-49018
    //DIRECT-49074

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adGroupId;
    Long adId;

    @Before
    public void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);
        adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
    }

    @Test
    public void checkStatusPostModerateAfterRejected() {
        jooqSteps(LOGIN).bannersSteps().setBannerStatusPostModerate(adId, BannersStatuspostmoderate.Rejected);
        BannersStatuspostmoderate statusBefore = jooqSteps(LOGIN)
                .bannersSteps().getBanner(adId).getStatuspostmoderate();
        assumeThat("StatusPostModerate = Rejected",
                statusBefore, equalTo(BannersStatuspostmoderate.Rejected));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannersStatuspostmoderate statusAfter = jooqSteps(LOGIN)
                .bannersSteps().getBanner(adId).getStatuspostmoderate();
        assertThat("StatusPostModerate = Rejected",
                statusAfter, equalTo(BannersStatuspostmoderate.Rejected));
    }

    @Test
    public void checkStatusPostModerateAfterNew() {
        jooqSteps(LOGIN).bannersSteps().setBannerStatusPostModerate(adId, BannersStatuspostmoderate.New);
        BannersStatuspostmoderate statusBefore = jooqSteps(LOGIN)
                .bannersSteps().getBanner(adId).getStatuspostmoderate();
        assumeThat("StatusPostModerate = New",
                statusBefore, equalTo(BannersStatuspostmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannersStatuspostmoderate statusAfter = jooqSteps(LOGIN)
                .bannersSteps().getBanner(adId).getStatuspostmoderate();
        assertThat("StatusPostModerate = No", statusAfter, equalTo(BannersStatuspostmoderate.No));
    }

    @Test
    public void checkPhraseStatusModerateAfterNew() {
        jooqSteps(LOGIN).adGroupsSteps().setPhrasesStatusModerate(adGroupId,
                PhrasesStatusmoderate.New, PhrasesStatuspostmoderate.New);
        PhrasesStatusmoderate statusBefore = jooqSteps(LOGIN)
                .adGroupsSteps().getPhrases(adGroupId).getStatusmoderate();
        assumeThat("StatusModerate = New", statusBefore, equalTo(PhrasesStatusmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        PhrasesStatusmoderate statusAfter = jooqSteps(LOGIN)
                .adGroupsSteps().getPhrases(adGroupId).getStatusmoderate();
        assertThat("StatusModerate = Ready", statusAfter, equalTo(PhrasesStatusmoderate.Ready));
    }

    @Test
    public void checkPhraseStatusModerateAfterYes() {
        jooqSteps(LOGIN).adGroupsSteps().setPhrasesStatusModerate(adGroupId,
                PhrasesStatusmoderate.Yes, PhrasesStatuspostmoderate.No);
        PhrasesStatusmoderate statusBefore = jooqSteps(LOGIN)
                .adGroupsSteps().getPhrases(adGroupId).getStatusmoderate();
        assumeThat("StatusModerate = Yes", statusBefore, equalTo(PhrasesStatusmoderate.Yes));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        PhrasesStatusmoderate statusAfter = jooqSteps(LOGIN)
                .adGroupsSteps().getPhrases(adGroupId).getStatusmoderate();
        assertThat("StatusModerate = Yes", statusAfter, equalTo(PhrasesStatusmoderate.Yes));
    }

    @Test
    public void checkCampaignStatusModerateAfterNew() {
        CampaignsStatusmoderate statusBefore = jooqSteps(LOGIN)
                .campaignsSteps().getCampaignById(campaignId).getStatusmoderate();
        assumeThat("StatusModerate = New", statusBefore, equalTo(CampaignsStatusmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        CampaignsStatusmoderate statusAfter = jooqSteps(LOGIN)
                .campaignsSteps().getCampaignById(campaignId).getStatusmoderate();
        assertThat("StatusModerate = Ready", statusAfter, equalTo(CampaignsStatusmoderate.Ready));
    }

    @Test
    public void checkCampaignStatusModerateAfterNo() {
        jooqSteps(LOGIN).campaignsSteps().updateCampaigns(
                new CampaignsRecord().setCid(campaignId).setStatusmoderate(CampaignsStatusmoderate.No));
        CampaignsStatusmoderate statusBefore = jooqSteps(LOGIN)
                .campaignsSteps().getCampaignById(campaignId).getStatusmoderate();
        assumeThat("StatusModerate = No", statusBefore, equalTo(CampaignsStatusmoderate.No));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        CampaignsStatusmoderate statusAfter = jooqSteps(LOGIN)
                .campaignsSteps().getCampaignById(campaignId).getStatusmoderate();
        assertThat("StatusModerate = Ready", statusAfter, equalTo(CampaignsStatusmoderate.Ready));
    }

    @Test
    public void checkCampaignStatusModerateAfterYes() {
        jooqSteps(LOGIN).campaignsSteps().updateCampaigns(
                new CampaignsRecord().setCid(campaignId).setStatusmoderate(CampaignsStatusmoderate.Yes));
        CampaignsStatusmoderate statusBefore = jooqSteps(LOGIN)
                .campaignsSteps().getCampaignById(campaignId).getStatusmoderate();
        assumeThat("StatusModerate = Yes", statusBefore, equalTo(CampaignsStatusmoderate.Yes));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        CampaignsStatusmoderate statusAfter = jooqSteps(LOGIN)
                .campaignsSteps().getCampaignById(campaignId).getStatusmoderate();
        assertThat("StatusModerate = Yes", statusAfter, equalTo(CampaignsStatusmoderate.Yes));
    }


    private DirectJooqDbSteps jooqSteps(String login) {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
    }
}
