package ru.yandex.autotests.direct.api.ads.moderate;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.DirectObjectType;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 20.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка влияния Moderate на статусы объектов")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckFakeStatusesAfterModerateTest {

    private static final String LOGIN = AdsLogins.CLIENT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adGroupId;
    Long adId;
    Long keywordId;

    @Parameterized.Parameter(0)
    public DirectObjectType type;

    @Parameterized.Parameters(name = "type = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {DirectObjectType.TEXT},
                {DirectObjectType.MOBILE_CONTENT},
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(type.getCampaignType());
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, type.getAdGroupType());
        adId = api.userSteps.adsSteps().addDefaultAd(adGroupId, type.getBannerType());
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    public void checkStatusPostModerateAfterRejected() {
        BannersStatuspostmoderate originalStatus = BannersStatuspostmoderate.Rejected;
        BannersStatuspostmoderate finalStatus = BannersStatuspostmoderate.Rejected;
        checkBannerStatusPostModerate(originalStatus, finalStatus);
    }

    @Test
    public void checkStatusPostModerateAfterNew() {
        BannersStatuspostmoderate originalStatus = BannersStatuspostmoderate.New;
        BannersStatuspostmoderate finalStatus = BannersStatuspostmoderate.No;
        checkBannerStatusPostModerate(originalStatus, finalStatus);
    }

    private void checkBannerStatusPostModerate(BannersStatuspostmoderate originalStatus,
            BannersStatuspostmoderate finalStatus)
    {
        jooqSteps(LOGIN).bannersSteps().setBannerStatusPostModerate(adId, originalStatus);
        BannersStatuspostmoderate statusBefore = jooqSteps(LOGIN)
                .bannersSteps().getBanner(adId).getStatuspostmoderate();
        assumeThat("Correct original status", statusBefore, equalTo(originalStatus));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannersStatuspostmoderate statusAfter = jooqSteps(LOGIN)
                .bannersSteps().getBanner(adId).getStatuspostmoderate();
        assertThat("Correct status after ads.moderate", statusAfter, equalTo(finalStatus));
    }

    @Test
    public void checkPhraseStatusModerateAfterNew() {
        PhrasesStatusmoderate statusBefore = jooqSteps(LOGIN).adGroupsSteps().getPhrases(adGroupId).getStatusmoderate();
        assumeThat("StatusModerate = New", statusBefore, equalTo(PhrasesStatusmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        PhrasesStatusmoderate statusAfter = jooqSteps(LOGIN).adGroupsSteps().getPhrases(adGroupId).getStatusmoderate();
        assertThat("StatusModerate = Ready", statusAfter, equalTo(PhrasesStatusmoderate.Ready));
    }

    @Test
    public void checkPhraseStatusModerateAfterYes() {
        jooqSteps(LOGIN).adGroupsSteps().setPhrasesStatusModerate(adGroupId,
                PhrasesStatusmoderate.Yes, PhrasesStatuspostmoderate.New);
        PhrasesStatusmoderate statusBefore = jooqSteps(LOGIN).adGroupsSteps().getPhrases(adGroupId).getStatusmoderate();
        assumeThat("StatusModerate = Yes", statusBefore, equalTo(PhrasesStatusmoderate.Yes));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        PhrasesStatusmoderate statusAfter = jooqSteps(LOGIN).adGroupsSteps().getPhrases(adGroupId).getStatusmoderate();
        assertThat("StatusModerate = Yes", statusAfter, equalTo(PhrasesStatusmoderate.Yes));
    }

    @Test
    public void checkCampaignStatusModerateAfterNew() {
        CampaignsStatusmoderate originalStatus = CampaignsStatusmoderate.New;
        CampaignsStatusmoderate finalStatus = CampaignsStatusmoderate.Ready;
        checkCampaignStatusModerate(originalStatus, finalStatus);
    }

    @Test
    public void checkCampaignStatusModerateAfterNo() {
        CampaignsStatusmoderate originalStatus = CampaignsStatusmoderate.No;
        CampaignsStatusmoderate finalStatus = CampaignsStatusmoderate.Ready;
        checkCampaignStatusModerate(originalStatus, finalStatus);
    }

    @Test
    public void checkCampaignStatusModerateAfterYes() {
        CampaignsStatusmoderate originalStatus = CampaignsStatusmoderate.Yes;
        CampaignsStatusmoderate finalStatus = CampaignsStatusmoderate.Yes;
        checkCampaignStatusModerate(originalStatus, finalStatus);
    }

    private void checkCampaignStatusModerate(CampaignsStatusmoderate originalStatus,
            CampaignsStatusmoderate finalStatus)
    {
        jooqSteps(LOGIN).campaignsSteps().updateCampaigns(
                new CampaignsRecord().setCid(campaignId).setStatusmoderate(originalStatus));
        CampaignsStatusmoderate statusBefore = jooqSteps(LOGIN)
                .campaignsSteps().getCampaignById(campaignId).getStatusmoderate();
        assumeThat("Correct original status", statusBefore, equalTo(originalStatus));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        CampaignsStatusmoderate statusAfter = jooqSteps(LOGIN)
                .campaignsSteps().getCampaignById(campaignId).getStatusmoderate();
        assertThat("Correct status after ads.moderate", statusAfter, equalTo(finalStatus));
    }

    private DirectJooqDbSteps jooqSteps(String login) {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
    }
}
