package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPhoneflag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка влияния Moderate для динамического текстового объявления на статусы дочерних объектов объявления")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
@Tag(TagDictionary.TRUNK)
public class CheckFakeStatusesOfSubObjectsAfterModerateDynamicTextAdTest {

    private static final String CLIENT = AdsLogins.CLIENT20;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adGroupId;
    Long adId;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        Long sitelinksSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        String adImageHash = api.userSteps.imagesSteps().configLoginImages(CLIENT, ImageType.REGULAR, 1)[0];
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd()
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinksSetId)
                        .withAdImageHash(adImageHash))
                .withAdGroupId(adGroupId));
    }

    @Test
    public void checkPhoneFlag() {
        BannersPhoneflag flagBefore = jooqSteps(CLIENT).bannersSteps().getBanner(adId).getPhoneflag();
        assumeThat("phoneflag = New", flagBefore, equalTo(BannersPhoneflag.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannersPhoneflag flagAfter = jooqSteps(CLIENT).bannersSteps().getBanner(adId).getPhoneflag();
        assertThat("phoneflag = Ready", flagAfter, equalTo(BannersPhoneflag.Ready));
    }

    @Test
    public void checkStatusSitelinksModerate() {
        BannersStatussitelinksmoderate statusBefore = jooqSteps(CLIENT)
                .bannersSteps().getBanner(adId).getStatussitelinksmoderate();
        assumeThat("StatusSitelinksModerate = New",
                statusBefore, equalTo(BannersStatussitelinksmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannersStatussitelinksmoderate statusAfter = jooqSteps(CLIENT)
                .bannersSteps().getBanner(adId).getStatussitelinksmoderate();
        assertThat("StatusSitelinksModerate = Ready",
                statusAfter, equalTo(BannersStatussitelinksmoderate.Ready));
    }

    @Test
    public void checkImageStatusModerate() {
        BannerImagesStatusmoderate statusBefore = jooqSteps(CLIENT)
                .imagesSteps().getBannerImagesByBid(adId).getStatusmoderate();
        assumeThat("ImageStatusModerate = New", statusBefore, equalTo(BannerImagesStatusmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannerImagesStatusmoderate statusAfter = jooqSteps(CLIENT)
                .imagesSteps().getBannerImagesByBid(adId).getStatusmoderate();
        assertThat("ImageStatusModerate = Ready", statusAfter, equalTo(BannerImagesStatusmoderate.Ready));
    }

    private DirectJooqDbSteps jooqSteps(String login) {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
    }
}
