package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 23.03.16.
 * https://st.yandex-team.ru/TESTIRT-8629
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка влияния Moderate для мобильного объявления на статусы дочерних объектов объявления")
@Issue("https://st.yandex-team.ru/DIRECT-50153")
public class CheckFakeStatusesOfSubObjectsAfterModerateMobileAppAdTest {

    private static final String CLIENT = AdsLogins.CLIENT28;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adGroupId;
    Long adId;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        String adImageHash = api.userSteps.imagesSteps().configLoginImages(CLIENT, ImageType.WIDE, 3)[0];
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withMobileAppAd(new MobileAppAdAddMap().defaultMobileAppAd()
                        .withAdImageHash(adImageHash))
                .withAdGroupId(adGroupId));
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    public void checkImageStatusModerate() {
        BannerImagesStatusmoderate statusBefore = jooqSteps(CLIENT)
                .imagesSteps().getBannerImagesByBid(adId).getStatusmoderate();
        assumeThat("ImageStatusModerate = New", statusBefore, equalTo(BannerImagesStatusmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannerImagesStatusmoderate statusAfter = jooqSteps(CLIENT)
                .imagesSteps().getBannerImagesByBid(adId).getStatusmoderate();
        assertThat("ImageStatusModerate = Ready", statusAfter, equalTo(BannerImagesStatusmoderate.Ready));
    }

    private DirectJooqDbSteps jooqSteps(String login) {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
    }
}
