package ru.yandex.autotests.direct.api.ads.moderate;

import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPhoneflag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.UsersOptionsStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersOptionsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directapi.model.Logins.SUPER_LOGIN;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 05.06.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка влияния Moderate на статусы дочерних объектов объявления")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
public class CheckFakeStatusesOfSubObjectsAfterModerateTest {

    private static final String LOGIN = AdsLogins.CLIENT5;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api.as(SUPER_LOGIN));

    Long campaignId;
    Long adGroupId;
    Long adId;
    Long keywordId;

    @Before
    public void initTest() {
        api.as(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignId);
        Long sitelinksSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        String adImageHash = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.REGULAR, 1)[0];
        adId = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withTextAd(new TextAdAddMap().defaultTextAd()
                        .withVCardId(vCardId)
                        .withSitelinkSetId(sitelinksSetId)
                        .withAdImageHash(adImageHash))
                .withAdGroupId(adGroupId));
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    public void checkPhoneFlag() {
        BannersPhoneflag flagBefore = jooqSteps(LOGIN).bannersSteps().getBanner(adId).getPhoneflag();
        assumeThat("phoneflag = New", flagBefore, equalTo(BannersPhoneflag.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannersPhoneflag flagAfter = jooqSteps(LOGIN).bannersSteps().getBanner(adId).getPhoneflag();
        assertThat("phoneflag = Ready", flagAfter, equalTo(BannersPhoneflag.Ready));
    }

    @Test
    public void checkStatusSitelinksModerate() {
        BannersStatussitelinksmoderate statusBefore = jooqSteps(LOGIN)
                .bannersSteps().getBanner(adId).getStatussitelinksmoderate();
        assumeThat("StatusSitelinksModerate = New",
                statusBefore, equalTo(BannersStatussitelinksmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannersStatussitelinksmoderate statusAfter = jooqSteps(LOGIN)
                .bannersSteps().getBanner(adId).getStatussitelinksmoderate();
        assertThat("StatusSitelinksModerate = Ready",
                statusAfter, equalTo(BannersStatussitelinksmoderate.Ready));
    }

    @Test
    public void checkImageStatusModerate() {
        BannerImagesStatusmoderate statusBefore = jooqSteps(LOGIN)
                .imagesSteps().getBannerImagesByBid(adId).getStatusmoderate();
        assumeThat("ImageStatusModerate = New", statusBefore, equalTo(BannerImagesStatusmoderate.New));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannerImagesStatusmoderate statusAfter = jooqSteps(LOGIN)
                .imagesSteps().getBannerImagesByBid(adId).getStatusmoderate();
        assertThat("ImageStatusModerate = Ready", statusAfter, equalTo(BannerImagesStatusmoderate.Ready));
    }

    @Test
    public void checkPostModerateTable_clientWithoutPostModerateOption_recordNotCreated() {
        checkPostModerate(UsersOptionsStatuspostmoderate.No, nullValue());
    }

    @Test
    public void checkPostModerateTable_clientWithPostModerateOption_recordCreated() {
        checkPostModerate(UsersOptionsStatuspostmoderate.Yes, notNullValue());
    }

    private void checkPostModerate(UsersOptionsStatuspostmoderate postModerate, Matcher<Object> objectMatcher) {
        UsersOptionsRecord usersOptions = jooqSteps(LOGIN).usersOptionsSteps()
                .getUsersOptions(Long.valueOf(User.get(LOGIN).getPassportUID()));
        UsersOptionsStatuspostmoderate initialStatusPostmoderate = usersOptions.getStatuspostmoderate();
        setUserOptionsStatusPostmoderate(usersOptions, postModerate);

        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        assertThat("ppc.post_moderate", jooqSteps(LOGIN)
                .moderationSteps().getPostModerateRecord(adId), objectMatcher);

        setUserOptionsStatusPostmoderate(usersOptions, initialStatusPostmoderate);
    }

    private void setUserOptionsStatusPostmoderate(UsersOptionsRecord usersOptions,
            UsersOptionsStatuspostmoderate postModerate)
    {
        usersOptions.setStatuspostmoderate(postModerate);
        jooqSteps(LOGIN).usersOptionsSteps().updateUsersOptions(usersOptions);
    }

    private DirectJooqDbSteps jooqSteps(String login) {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(login);
    }
}
