package ru.yandex.autotests.direct.api.ads.moderate;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.DirectObjectType;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 09.08.16.
 * https://st.yandex-team.ru/TESTIRT-10033
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка влияния Moderate на статусы модерации графического объявления")
@Issue("https://st.yandex-team.ru/DIRECT-56920")
@RunWith(Parameterized.class)
public class CheckImageStatusModerateAfterModerateImageAdTest {

    private static final String CLIENT = AdsLogins.CLIENT38;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;
    private Long adGroupId;
    private Long adId;
    private static String adImageHash;

    @Parameterized.Parameter(0)
    public DirectObjectType type;

    @Parameterized.Parameters(name = "type = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {DirectObjectType.TEXT},
                {DirectObjectType.MOBILE_CONTENT},
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void beforeClass() {
        adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1);
    }

    @Before
    public void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(type.getCampaignType());
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, type.getAdGroupType());
        adId = api.userSteps.adsSteps().addAdWithAdImageHash(adGroupId, type.getAdGroupType(), BannerType.IMAGE_AD, adImageHash);
        Long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        String bannerStatusModerate = api.userSteps.bannersFakeSteps().getBannerParams(adId).getStatusModerate();
        assumeThat("banners.StatusModerate = New", bannerStatusModerate, equalTo(Status.NEW));
        String imageAdStatusmoderate = api.userSteps.bannersFakeSteps().getBannerParams(adId).getImageadStatusModerate();
        assumeThat("images.StatusModerate = New", imageAdStatusmoderate, equalTo(Status.NEW));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
    }

    @Test
    public void checkBannersStatusModerate() {
        String bannerStatusModerate = api.userSteps.bannersFakeSteps().getBannerParams(adId).getStatusModerate();
        assertThat("banners.StatusModerate = Ready", bannerStatusModerate, equalTo(Status.READY));
    }

    @Test
    public void checkImagesStatusModerate() {
        String imageAdStatusmoderate = api.userSteps.bannersFakeSteps().getBannerParams(adId).getImageadStatusModerate();
        assertThat("images.StatusModerate = Ready", imageAdStatusmoderate, equalTo(Status.READY));
    }
}
