package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 22.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Влияние отправки на модерацию одного баннера на другие баннеры кампании или группы")
@Issue("https://st.yandex-team.ru/DIRECT-40261")
@Tag(TagDictionary.TRUNK)
public class CheckInfluenceToOtherAdsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId1;
    private static Long adId2;
    private static Long adIdFromOtherGroup;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId1 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId1);
        adId2 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId1);
        adIdFromOtherGroup = api.userSteps.adsSteps().addDefaultTextAd(adGroupId2);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId1);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId2);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adIdFromOtherGroup);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId1), ExpectedResult.success(adId1));
    }

    @Test
    public void checkOtherAdFromSameAdGroup() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    public void checkAdFromOtherAdGroup() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adIdFromOtherGroup);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }
}
