package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 17.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Проверка предупреждений")
@Issue("https://st.yandex-team.ru/DIRECT-40261")
public class CheckWarningsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    private Long draftAd;
    private Long moderatedAd;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        draftAd = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        moderatedAd = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(draftAd);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
        api.userSteps.bannersFakeSteps().setStatusModerate(moderatedAd, Status.YES);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(moderatedAd);
        assumeThat("баннер промодерирован", bannerFakeInfo.getStatusModerate(), equalTo(Status.YES));
    }


    @Test
    public void moderateTwoAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(draftAd, draftAd),
                        ExpectedResult.warnings(draftAd,
                                new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)),
                        ExpectedResult.warnings(draftAd,
                                new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(draftAd);
        assertThat("баннер отправился на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
    }

    @Test
    public void moderateTwoModeratedAds() {
        //ToDo вопрос в AdsDesign
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(moderatedAd, moderatedAd),
                        ExpectedResult.create(nullValue(),
                                singletonList(new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)),
                                singletonList(new Notification(8300, Api5ErrorDetails.YOU_CAN_MODERATE_ONLY_DRAFT_AD))),
                        ExpectedResult.create(nullValue(),
                                singletonList(new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)),
                                singletonList(new Notification(8300, Api5ErrorDetails.YOU_CAN_MODERATE_ONLY_DRAFT_AD))));
    }
}
