package ru.yandex.autotests.direct.api.ads.moderate;

import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 17.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Id, которые должны вызывать ошибку")
@Issue("https://st.yandex-team.ru/DIRECT-40261")
@Tag(TagDictionary.TRUNK)
public class IdsNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adGroupId;
    Long id;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT_ELSE);
    }

    @Before
    public void createAd() {
        api.as(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(AdsLogins.CLIENT, adGroupId);
        id = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void moderateZeroId() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(0L),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    public void moderateNotMyId() {
        api.as(AdsLogins.CLIENT_ELSE);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    public void moderateDeletedId() {
        api.userSteps.adsSteps().adsDelete(id);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    public void moderateIdFromDeletedCampaign() {
        api.userSteps.campaignSteps().campaignsDelete(campaignId);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    public void moderateArchivedId() {
        api.userSteps.adsSteps().adsModerate(id);
        api.userSteps.adsSteps().adsArchive(id);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.AD_IS_ARCHIVED_AND_CANT_BE_MODERATED)));
    }

    @Test
    public void moderateIdFromArchivedCampaign() {
        //DIRECT-41160
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.campaignFakeSteps().setLastShowTimeAnHourAndMinuteAgo(campaignId);
        api.userSteps.campaignSteps().campaignsSuspend(campaignId);
        api.userSteps.campaignSteps().campaignsArchive(campaignId);
        List<CampaignGetItem> campaignResponse = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignId).withStates(CampaignStateEnum.ARCHIVED))
                        .withFieldNames(CampaignFieldEnum.ID));
        assumeThat("кампания заархивировалась", campaignResponse, beanDifferV5(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap().withId(campaignId).getBean())
        ));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id),
                        ExpectedResult.errors(
                                new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)));
    }

    @Test
    public void moderateNonExistentId() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(id + 100000),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    public void moderateNegativeId() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(-id),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }
}
