package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.PerfCreativesSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.AdsSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 20.09.16.
 * https://st.yandex-team.ru/TESTIRT-10249
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Проверка вызова метода Ads.moderate для ГО с креативом")
@Issue("https://st.yandex-team.ru/DIRECT-56944")
public class ModerateAdWithCreativeTest {
    //DIRECT-58635

    private final static String CLIENT = AdsLogins.CLIENT48;
    private static PerfCreativesSteps creativesSteps;
    private static AdsSteps adsSteps;
    private static long clientId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long creativeId;
    private Long anotherCreativeId;

    @BeforeClass
    public static void beforeClass() {
        creativesSteps = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps();
        clientId = Long.parseLong(User.get(CLIENT).getClientID());
        adsSteps = api.userSteps.adsSteps();
    }

    @Before
    public void before() {
        creativeId = creativesSteps.saveDefaultCanvasCreativesForClient(clientId);
        anotherCreativeId = creativesSteps.saveDefaultCanvasCreativesForClient(clientId);
    }

    @Test
    public void moderateTextAd() {
        Long adGroupId = createAdGroup(CampaignType.TEXT, AdGroupType.BASE);
        Long bidWithCreative = adsSteps.addDefaultTextAdBuilderAd(adGroupId, creativeId);
        adsSteps.shouldGetResultOnModerate(new IdsCriteriaMap().withIds(bidWithCreative),
                ExpectedResult.success());
    }

    @Test
    public void moderateTwoTextAds() {
        Long adGroupId = createAdGroup(CampaignType.TEXT, AdGroupType.BASE);
        Long bidWithCreative = adsSteps.addDefaultTextAdBuilderAd(adGroupId, creativeId);
        Long bidWithAnotherCreative = adsSteps.addDefaultTextAdBuilderAd(adGroupId, anotherCreativeId);
        adsSteps.shouldGetResultOnModerate(new IdsCriteriaMap().withIds(bidWithCreative, bidWithAnotherCreative),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void moderateTwoTextAdsWithSameCreative() {
        Long adGroupId = createAdGroup(CampaignType.TEXT, AdGroupType.BASE);
        Long bidWithCreative = adsSteps.addDefaultTextAdBuilderAd(adGroupId, creativeId);
        Long bidWithSameCreative = adsSteps.addDefaultTextAdBuilderAd(adGroupId, creativeId);
        adsSteps.shouldGetResultOnModerate(new IdsCriteriaMap().withIds(bidWithCreative, bidWithSameCreative),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void moderateMobileAppAd() {
        Long adGroupId = createAdGroup(CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT);
        Long bidWithCreative = adsSteps.addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);
        adsSteps.shouldGetResultOnModerate(new IdsCriteriaMap().withIds(bidWithCreative),
                ExpectedResult.success());
    }

    @Test
    public void moderateTwoMobileAppAds() {
        Long adGroupId = createAdGroup(CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT);
        Long bidWithCreative = adsSteps.addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);
        Long bidWithAnotherCreative = adsSteps.addDefaultMobileAppAdBuilderAd(adGroupId, anotherCreativeId);
        adsSteps.shouldGetResultOnModerate(new IdsCriteriaMap().withIds(bidWithCreative, bidWithAnotherCreative),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    public void moderateTwoMobileAppAdsWithSameCreative() {
        Long adGroupId = createAdGroup(CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT);
        Long bidWithCreative = adsSteps.addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);
        Long bidWithSameCreative = adsSteps.addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);
        adsSteps.shouldGetResultOnModerate(new IdsCriteriaMap().withIds(bidWithCreative, bidWithSameCreative),
                ExpectedResult.success(), ExpectedResult.success());
    }

    private Long createAdGroup(CampaignType text, AdGroupType base) {
        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(text);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, base);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        return adGroupId;
    }
}
