package ru.yandex.autotests.direct.api.ads.moderate;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 20.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Попытка отправить на модерацию баннеры с разными статусами. Отправлять можно только черновик")
@Issue("https://st.yandex-team.ru/DIRECT-40261")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ModerateBannersOfDifferentStatusTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adId;

    @Parameterized.Parameter(0)
    public String statusModerate;

    @Parameterized.Parameters(name = "statusModerate = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Status.YES},
                {Status.NO},
                {Status.SENT},
                {Status.SENDING},
                {Status.READY},
        };
        return Arrays.asList(data);
    }

    @Before
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, statusModerate);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннер имеет правильный StatusModerate", bannerFakeInfo.getStatusModerate(), equalTo(statusModerate));
    }

    @Test
    public void moderateNotDraft() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId),
                        ExpectedResult.errors(new Notification(8300, Api5ErrorDetails.YOU_CAN_MODERATE_ONLY_DRAFT_AD)));
    }
}
