package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.ModerateRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Модерация объявление типа cpm_banner")
@Issue("https://st.yandex-team.ru/DIRECT-82660")
public class ModerateCpcVideoAdTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId;
    private Long creativeId;

    @Before
    public void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        creativeId = api.userSteps.getDirectJooqDbSteps().useShard(shard).perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(LOGIN).getClientID()));
        Long campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage())
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultServingOff()))));
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        adId = api.userSteps.adsSteps().addDefaultTextAdBuilderAd(adGroupId, creativeId);

        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(adId, BannersBannerType.cpc_video);
    }

    @Test
    public void moderateCpmBannerAd() {
        api.userSteps.adsSteps().shouldGetResultOnModerate(
                new ModerateRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.success(adId));
        BannersPerformanceRecord bannersPerformance =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).bannersPerformanceSteps()
                        .getBannersPerformance(adId, creativeId);
        assertThat("получен ожидаемый статус Ready",
                bannersPerformance.getStatusmoderate(),
                equalTo(BannersPerformanceStatusmoderate.Ready));
    }
}
