package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Отправка на модерацию одного или нескольких динамических текстовых баннеров")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
@Tag(TagDictionary.TRUNK)
public class ModerateDynamicTextAdsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    Long campaignId;
    Long adId1;
    Long adId2;
    Long adGroupId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(AdsLogins.CLIENT);
    }

    @Before
    public void createObjects() {
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);
        adId1 = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        adId2 = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    public void moderateOneAdTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId1), ExpectedResult.success(adId1));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
    }

    @Test
    public void moderateTwoAdsTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId1, adId2),
                        ExpectedResult.success(adId1), ExpectedResult.success(adId2));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
    }

    @Test
    public void moderateOneAdWithoutConditions() {
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bidsDynamicSteps().deleteBidsDynamicIdsByPid(adGroupId);
        api.userSteps.getDirectJooqDbSteps()
                .dynamicConditionsSteps()
                .deleteDynamicConditionsByPid(adGroupId);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId1),
                        ExpectedResult.errors(new Notification(8300,
                                Api5ErrorDetails.UNABLE_MODERATE_AD_WITHOUT_SHOW_CONDITIONS)));
    }
}
