package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 11.08.16.
 * https://st.yandex-team.ru/TESTIRT-10037
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Отправка на модерацию динамических текстовых баннеров с фидом")
@Issue("https://st.yandex-team.ru/DIRECT-55149")
public class ModerateDynamicTextFeedAdsTest {
    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;
    private static DirectJooqDbSteps jooqDbSteps;

    Long campaignId;
    Long adId;
    Long adGroupId;
    Long feedId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
    }

    @Before
    public void createObjects() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(client).getClientID());
        assumeThat(
                "баннер является черновиком",
                jooqDbSteps.bannersSteps().getBanner(adId).getStatusmoderate(),
                equalTo(BannersStatusmoderate.New)
        );
    }

    @Test
    public void moderateDynamicTextFeedAdWithoutShowConditions() {
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId, feedId);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId),
                        ExpectedResult.errors(new Notification(8300,
                                Api5ErrorDetails.UNABLE_MODERATE_AD_WITHOUT_SHOW_CONDITIONS)));
    }

    @Test
    public void moderateAdTest() {
        api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId, feedId);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("баннер отправился на модерцию", bannerFakeInfo.getStatusModerate(), equalTo(Status.READY));
    }
}
