package ru.yandex.autotests.direct.api.ads.moderate;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.common.api45.RetargetingCondition;
import ru.yandex.autotests.directapi.common.api45.RetargetingGoal;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.retargeting.RetargetingMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 20.04.15.
 * https://st.yandex-team.ru/TESTIRT-5223
 */
@Aqua.Test
@Features(AdsFeatures.MODERATE)
@Description("Отправить на модерацию можно только баннер с условиями показа (фразы или ретаргетинг)")
@Issue("https://st.yandex-team.ru/DIRECT-40261")
@Tag(TagDictionary.TRUNK)
public class ShowConditionsTest {

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adGroupId;
    Long adId;

    private static Integer retargetingConditionID;

    @BeforeClass
    public static void testCampaign() {
        api.as(Logins.SUPER_LOGIN).userSteps.deleteAllRetargetingListsByLogin(client);
        RetargetingGoal[] goals = api.as(client).userSteps.retargetingSteps().getRetargetingGoals(client);
        assumeThat("Список целей в метрике неверен", goals.length, greaterThan(1));
        List<RetargetingCondition> conditions = api.userSteps.retargetingSteps().addConditionsForUser(client, 1);
        retargetingConditionID = conditions.get(0).getRetargetingConditionID();
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннер является черновиком", bannerFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    public void moderateAdWithKeyword() {
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
    }

    @Test
    public void moderateAdWithRetargeting() {
        api.userSteps.retargetingSteps().retargetingAdd(
                client,
                new RetargetingMap(api.type())
                        .withAdID(adId)
                        .withCurrency(Currency.RUB)
                        .withRetargetingConditionID(retargetingConditionID)
                        .withContextPrice(MoneyCurrency.get(Currency.RUB).getMinPrice().floatValue()));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
    }

    @Test
    public void moderateAdWithKeywordAndRetargeting() {
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.retargetingSteps().retargetingAdd(
                client,
                new RetargetingMap(api.type())
                        .withAdID(adId)
                        .withRetargetingConditionID(retargetingConditionID)
                        .withCurrency(Currency.RUB)
                        .withContextPrice(MoneyCurrency.get(Currency.RUB).getMinPrice().floatValue()));
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
    }

    @Test
    public void moderateAdWithoutShowConditions() {
        api.userSteps.adsSteps()
                .shouldGetResultOnModerate(new IdsCriteriaMap().withIds(adId),
                        ExpectedResult.errors(new Notification(8300,
                                Api5ErrorDetails.UNABLE_MODERATE_AD_WITHOUT_SHOW_CONDITIONS)));
    }
}
