package ru.yandex.autotests.direct.api.ads.moderate;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersPerformanceRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * https://st.yandex-team.ru/DIRECT-69183
 */
@Aqua.Test
@Description("Проверка работы поля CreativeId")
@Issue("https://st.yandex-team.ru/DIRECT-68620")
@Features(AdsFeatures.MODERATE)
public class VideoExtensionStatusModerateTest {
    private static String LOGIN = AdsLogins.CLIENT;
    private static Long adGroupId;
    private static Long creativeId;
    private static Long adId;
    private static BannersPerformanceRecord bannersPerformance;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void addCamp(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultVideoCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()), 1L);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        adId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withVideoExtension(creativeId))
                        .withAdGroupId(adGroupId)
        );
        bannersPerformance =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).bannersPerformanceSteps()
                        .getBannersPerformance(adId, creativeId);
        assumeThat("получен ожидаемый статус New",
                bannersPerformance.getStatusmoderate(),
                equalTo(BannersPerformanceStatusmoderate.New));
    }

    @Test
    public void moderateAdWithVideo() {
        api.userSteps.adsSteps().adsModerate(adId);
        bannersPerformance =
                api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).bannersPerformanceSteps()
                        .getBannersPerformance(adId, creativeId);
        assertThat("получен ожидаемый статус Ready",
                bannersPerformance.getStatusmoderate(),
                equalTo(BannersPerformanceStatusmoderate.Ready));
    }
}

