package ru.yandex.autotests.direct.api.ads.resume;

import com.yandex.direct.api.v5.ads.ResumeResponse;
import com.yandex.direct.api.v5.general.ActionResult;
import com.yandex.direct.api.v5.general.ExceptionNotification;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.ads.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 16.04.15.
 * https://st.yandex-team.ru/TESTIRT-5025
 */
@Aqua.Test
@Features(AdsFeatures.RESUME)
@Description("Пообъектная обработка запроса")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
public class DiscreteValidationTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adId;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannersStopped(adId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннер остановлен", bannerFakeInfo.getStatusShow(), equalTo(Status.NO));
    }

    @Test
    public void resumeValidAndInvalidAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnResume(new IdsCriteriaMap().withIds(adId, -adId),
                        ExpectedResult.success(adId),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("баннер запустился", bannerFakeInfo.getStatusShow(), equalTo(Status.YES));
    }

    @Test
    public void resumeInvalidAndValidAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnResume(new IdsCriteriaMap().withIds(-adId, adId),
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)),
                        ExpectedResult.success(adId));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assertThat("баннер запустился", bannerFakeInfo.getStatusShow(), equalTo(Status.YES));
    }

    @Test
    public void resumeTwoInvalidAds() {
        Notification duplicateWarning = new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST);
        Notification notFoundError = new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND);
        ActionResult expected = new ActionResult();
        expected.setErrors(singletonList((ExceptionNotification) notFoundError.getBean()));
        expected.setWarnings(singletonList((ExceptionNotification) duplicateWarning.getBean()));

        ResumeResponse response = api.userSteps.adsSteps().adsResume(new ResumeRequestMap()
                .withSelectionCriteria(new IdsCriteriaMap().withIds(-adId, -adId)));

        response.getResumeResults().forEach(actionResult ->
                assertThat("некорректный результат", actionResult, equalTo(expected)));
    }
}
