package ru.yandex.autotests.direct.api.ads.resume;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 16.04.15.
 * https://st.yandex-team.ru/TESTIRT-5025
 */
@Aqua.Test
@Features(AdsFeatures.RESUME)
@Description("Неправильный формат запроса")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
public class InvalidJSONTest {
    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static Long adGroupId;
    static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void invalidFieldInParams() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{adId});
        request.put(ResumeRequestMap.SELECTION_CRITERIA, idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsResume(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(ResumeRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void invalidFieldInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(IdsCriteriaMap.IDS, new Object[]{adId});
        request.put(capitalize(ResumeRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsResume(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(IdsCriteriaMap.IDS)));
    }

    @Test
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{adId});
        request.put(capitalize(ResumeRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsResume(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetailsJava.INVALID_REQUEST_FORMAT)
        );
    }

    @Test
    public void arrayInSelectionCriteria() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{adId});
        request.put(capitalize(ResumeRequestMap.SELECTION_CRITERIA), new Object[]{idsCriteria});
        api.userSteps.adsSteps().expectErrorOnAdsResume(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        path(ResumeRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    public void notArrayInIds() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), adId);
        request.put(capitalize(ResumeRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsResume(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        path(ResumeRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }

    @Test
    public void arrayOfStringsInIds() {
        JSONObject request = new JSONObject();
        JSONObject idsCriteria = new JSONObject();
        idsCriteria.put(capitalize(IdsCriteriaMap.IDS), new Object[]{"string"});
        request.put(capitalize(ResumeRequestMap.SELECTION_CRITERIA), idsCriteria);
        api.userSteps.adsSteps().expectErrorOnAdsResume(
                request,
                new Api5Error(8000, Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        path(ResumeRequestMap.SELECTION_CRITERIA, IdsCriteriaMap.IDS)));
    }
}
