package ru.yandex.autotests.direct.api.ads.resume;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 20.09.16.
 * https://st.yandex-team.ru/TESTIRT-10249
 */
@Aqua.Test
@Features(AdsFeatures.RESUME)
@Description("Проверка недоступности ГО объявлений с креативами в методе Ads.resume")
@Issue("https://st.yandex-team.ru/DIRECT-56944")
@RunWith(Parameterized.class)
public class ResumeAdWithCreativeTest {
    //DIRECT-58635

    private final static String CLIENT = AdsLogins.CLIENT48;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long bidWithCreative;

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameters(name = "CampaignType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }

    @Before
    public void before() {
        Long creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(CLIENT).perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                        Long.parseLong(User.get(CLIENT).getClientID()));
        api.as(CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        if (campaignType == CampaignType.TEXT){
            bidWithCreative = api.userSteps.adsSteps().addDefaultTextAdBuilderAd(adGroupId, creativeId);
        } else {
            bidWithCreative = api.userSteps.adsSteps().addDefaultMobileAppAdBuilderAd(adGroupId, creativeId);
        }
        api.userSteps.bannersFakeSteps().makeBannersStopped(bidWithCreative);
    }

    @Test
    public void tryResume() {
        api.userSteps.adsSteps().shouldGetResultOnResume(new IdsCriteriaMap().withIds(bidWithCreative),
                ExpectedResult.success());
    }
}
