package ru.yandex.autotests.direct.api.ads.resume;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 16.04.15.
 * https://st.yandex-team.ru/TESTIRT-5025
 */
@Aqua.Test
@Features(AdsFeatures.RESUME)
@Description("Запуск баннеров в различных статусах")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
public class ResumeBannersOfDifferentStatusTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adId;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void resumeSuspendedActiveAd() {
        api.userSteps.bannersFakeSteps().makeBannerActive(adId);
        api.userSteps.bannersFakeSteps().setStatusShow(adId, Status.NO);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннер стал активным", bannerFakeInfo.getStatusActive(), equalTo(Status.YES));
        api.userSteps.adsSteps()
                .shouldGetResultOnResume(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
    }

    @Test
    public void resumeDeclinedAd() {
        api.userSteps.bannersFakeSteps().makeBannersDeclined(adId);
        api.userSteps.bannersFakeSteps().setStatusShow(adId, Status.NO);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннер стал отклоненным", bannerFakeInfo.getStatusModerate(), equalTo(Status.NO));
        api.userSteps.adsSteps()
                .shouldGetResultOnResume(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
    }
}
