package ru.yandex.autotests.direct.api.ads.resume;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdsFeatures.RESUME)
@Description("Проверка включения кликовых видеообъявлений РМП")
@Issue("https://st.yandex-team.ru/DIRECT-132279")
public class ResumeMobileAppCpcAdVideoBuilderAdPositiveTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static final ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static final SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId;

    @Before
    public void before() {
        Long creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()));
        api.as(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(LOGIN);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId, LOGIN);
        adId = api.userSteps.adsSteps().addDefaultMobileAppCpcVideoAdBuilderAd(adGroupId, creativeId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);

        api.userSteps.bannersFakeSteps().makeBannersStopped(adId);
    }

    @Test
    public void tryResume() {
        api.userSteps.adsSteps()
                .shouldGetResultOnResume(new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(adId)), ExpectedResult.success());
    }
}

