package ru.yandex.autotests.direct.api.ads.resume;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.BsDeadDomainsHelper;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 22.06.16.
 * https://st.yandex-team.ru/TESTIRT-9494
 */
@Aqua.Test
@Features(AdsFeatures.RESUME)
@Description("Проверка вызова Ads.resume для выключенного объявления, домен которого остановлен БК")
@Issue("https://st.yandex-team.ru/DIRECT-53323")
public class ResumeStoppedByBSMonitoringAdTest {

    private static final String CLIENT_BS = Logins.CLIENT_FOR_BS_MONITORING;

    private static final String DEAD_DOMAIN = "deadtestdomain.xx";

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adId;

    @BeforeClass
    public static void beforeClass() {
        api.as(CLIENT_BS);
        int shard =  api.userSteps.getDirectJooqDbSteps().shardingSteps().getShardByLogin(CLIENT_BS);

        BsDeadDomainsHelper.addToBsDeadDomains(shard, api.userSteps.getDirectJooqDbSteps(), DEAD_DOMAIN);

        Long campaignId = api.userSteps.campaignSteps().addCampaignWithEnableSiteMonitoringSetting(YesNoEnum.YES);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        AddResponse response = api.userSteps.adsSteps().shouldGetResultOnAdd(new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(new TextAdAddMap()
                                .defaultTextAd()
                                .withHref("http://" + DEAD_DOMAIN))
                        .withAdGroupId(adGroupId)), ExpectedResult.success());
        adId = response.getAddResults().get(0).getId();
        api.userSteps.bannersFakeSteps().makeBannersStopped(adId);
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE));
        assumeThat("вернулся правильный State", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withState(StateEnum.SUSPENDED).getBean())));
    }

    @Test
    public void resumeAdAndCheckStateTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnResume(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
        GetResponse getResponse = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE));
        assertThat("вернулся правильный State", getResponse.getAds(), beanDiffer(
                Arrays.asList((AdGetItem) new AdGetItemMap()
                        .withId(adId)
                        .withState(StateEnum.OFF_BY_MONITORING).getBean())));
    }
}
