package ru.yandex.autotests.direct.api.ads.suspend;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 15.04.15.
 * https://st.yandex-team.ru/TESTIRT-4842
 */
@Aqua.Test
@Features(AdsFeatures.SUSPEND)
@Description("Проверка предупреждений")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
public class CheckWarningsTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    private Long resumedAd;
    private Long suspendedAd;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        resumedAd = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        suspendedAd = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannersModerated(resumedAd, suspendedAd);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(resumedAd);
        assumeThat("баннер запущен", bannerFakeInfo.getStatusShow(), equalTo(Status.YES));
        api.userSteps.bannersFakeSteps().setStatusShow(suspendedAd, Status.NO);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(suspendedAd);
        assumeThat("баннер остановлен", bannerFakeInfo.getStatusShow(), equalTo(Status.NO));
    }

    @Test
    public void suspendSuspendedAd() {
        api.userSteps.adsSteps()
                .shouldGetResultOnSuspend(new IdsCriteriaMap().withIds(suspendedAd),
                        ExpectedResult.warnings(suspendedAd, new Notification(10200)));
    }

    @Test
    public void suspendTwoResumedAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnSuspend(new IdsCriteriaMap().withIds(resumedAd, resumedAd),
                        ExpectedResult.warnings(resumedAd,
                                new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)),
                        ExpectedResult.warnings(resumedAd,
                                new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(resumedAd);
        assertThat("баннер остановился", bannerFakeInfo.getStatusShow(), equalTo(Status.NO));
    }

    @Test
    public void suspendTwoSuspendedAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnSuspend(new IdsCriteriaMap().withIds(suspendedAd, suspendedAd),
                        ExpectedResult.warnings(suspendedAd, new Notification(10200),
                                new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)),
                        ExpectedResult.warnings(suspendedAd, new Notification(10200),
                                new Notification(10000, Api5ErrorDetails.AD_MORE_THAN_ONCE_IN_REQUEST)));
    }

    @Test
    public void suspendResumedAndSuspendedAds() {
        api.userSteps.adsSteps()
                .shouldGetResultOnSuspend(new IdsCriteriaMap().withIds(resumedAd, suspendedAd),
                        ExpectedResult.success(resumedAd),
                        ExpectedResult.warnings(suspendedAd, new Notification(10200)));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(resumedAd);
        assertThat("баннер остановился", bannerFakeInfo.getStatusShow(), equalTo(Status.NO));
    }
}
