package ru.yandex.autotests.direct.api.ads.suspend;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 16.04.15.
 * https://st.yandex-team.ru/TESTIRT-4842
 */
@Aqua.Test
@Features(AdsFeatures.SUSPEND)
@Description("Остановка баннеров в различных статусах")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
public class SuspendBannersOfDifferentStatusTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    private Long adId;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
    }

    @Test
    public void suspendActiveAd() {
        api.userSteps.bannersFakeSteps().makeBannerActive(adId);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннер стал активным", bannerFakeInfo.getStatusActive(), equalTo(Status.YES));
        api.userSteps.adsSteps()
                .shouldGetResultOnSuspend(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
    }

    @Test
    public void suspendDeclinedAd() {
        api.userSteps.bannersFakeSteps().makeBannersDeclined(adId);
        api.userSteps.bannersFakeSteps().setStatusShow(adId, Status.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId);
        assumeThat("баннер стал отклоненным", bannerFakeInfo.getStatusModerate(), equalTo(Status.NO));
        api.userSteps.adsSteps()
                .shouldGetResultOnSuspend(new IdsCriteriaMap().withIds(adId), ExpectedResult.success(adId));
    }
}
