package ru.yandex.autotests.direct.api.ads.suspend;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 15.04.15.
 * https://st.yandex-team.ru/TESTIRT-4842
 */
@Aqua.Test
@Features(AdsFeatures.SUSPEND)
@Description("Остановка одного или нескольких баннеров")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SuspendBannersTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long campaignId;
    Long adId1;
    Long adId2;

    @Parameterized.Parameter(0)
    public CampaignType campaignType;

    @Parameterized.Parameter(1)
    public AdGroupType adGroupType;

    @Parameterized.Parameter(2)
    public BannerType bannerType;

    @Parameterized.Parameters(name = "bannerType = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT},
                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
    }

    @Before
    public void createObjects() {
        campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId1 = api.userSteps.adsSteps().addDefaultAd(adGroupId, bannerType);
        adId2 = api.userSteps.adsSteps().addDefaultAd(adGroupId, bannerType);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId1, adId2);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("баннер запущен", bannerFakeInfo.getStatusShow(), equalTo(Status.YES));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assumeThat("баннер запущен", bannerFakeInfo.getStatusShow(), equalTo(Status.YES));
    }

    @Test
    public void suspendOneAdTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnSuspend(new IdsCriteriaMap().withIds(adId1), ExpectedResult.success(adId1));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("баннер остановился", bannerFakeInfo.getStatusShow(), equalTo(Status.NO));
    }

    @Test
    public void suspendTwoAdsTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnSuspend(new IdsCriteriaMap().withIds(adId1, adId2),
                        ExpectedResult.success(adId1), ExpectedResult.success(adId2));
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("баннер остановился", bannerFakeInfo.getStatusShow(), equalTo(Status.NO));
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assertThat("баннер остановился", bannerFakeInfo.getStatusShow(), equalTo(Status.NO));
    }
}
