package ru.yandex.autotests.direct.api.ads.turbopages;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.api.ads.TurboPagesFeatures;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.db.steps.TurboLandingsSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.TurbolandingsPreset.cpm_geoproduct_preset;
import static ru.yandex.autotests.direct.db.models.jooq.ppc.enums.TurbolandingsPreset.empty_preset;

@Aqua.Test
@Features(TurboPagesFeatures.ADD)
@Description("Проверка получения турбо-страниц клиента")
@ParametersAreNonnullByDefault
public class AddTurbolandingTest {
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String client = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    private static long emptyTurbolandingId;
    private static long cpmGeoproductTurbolandingId;

    @Rule
    public Trashman trasher = new Trashman(api);

    private long adGroupId;

    @BeforeClass
    public static void createTurboPages() {
        DirectJooqDbSteps jooqSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        TurboLandingsSteps turboLandingsSteps = jooqSteps.turboLandingsSteps();
        long clientId = jooqSteps.usersSteps().getUser(client).getClientid();

        emptyTurbolandingId = turboLandingsSteps.createDefaultTurbolanding(clientId);
        turboLandingsSteps.updateTurboLandings(turboLandingsSteps
                .getTurboLanding(emptyTurbolandingId)
                .setPreset(empty_preset));
        cpmGeoproductTurbolandingId = turboLandingsSteps.createDefaultTurbolanding(clientId);
        turboLandingsSteps.updateTurboLandings(turboLandingsSteps
                .getTurboLanding(cpmGeoproductTurbolandingId)
                .setPreset(cpm_geoproduct_preset));
    }

    @Before
    public void setUp() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(client);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void addEmptyTurbolandingToTextBanner_success() {
        AddRequestMap request = new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(new TextAdAddMap().defaultTextAd().withTurboPageId(emptyTurbolandingId))
                        .withAdGroupId(adGroupId));
        api.userSteps.adsSteps().shouldGetResultOnAdd(request, ExpectedResult.success());
    }

    @Test
    public void addCpmGeoproductTurbolandingToTextBanner_success() {
        AddRequestMap request = new AddRequestMap()
                .withAds(new AdAddItemMap()
                        .withTextAd(new TextAdAddMap().defaultTextAd().withTurboPageId(cpmGeoproductTurbolandingId))
                        .withAdGroupId(adGroupId));
        api.userSteps.adsSteps().shouldGetResultOnAdd(request, ExpectedResult.success());
    }
}
