package ru.yandex.autotests.direct.api.ads.unarchive;

import java.util.List;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.contains;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 22.04.15.
 * https://st.yandex-team.ru/TESTIRT-5211
 */
@Aqua.Test
@Features(AdsFeatures.UNARCHIVE)
@Description("Разархивация объявлений из разных групп в одной кампании")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
public class AdsFromDifferentAdGroupsTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId1;
    private Long adId2;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId1 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId1);
        adId2 = api.userSteps.adsSteps().addDefaultTextAd(adGroupId2);

        api.userSteps.bannersFakeSteps().makeBannersModerated(adId1, adId2);
        api.userSteps.adsSteps().adsArchive(adId1, adId2);

        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId1, adId2))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE));
        List<StateEnum> states = response.getAds().stream().map(AdGetItem::getState).collect(toList());
        assumeThat("объявления заархивированы", states, contains(StateEnum.ARCHIVED, StateEnum.ARCHIVED));
    }

    @Test
    public void unarchiveTwoAdsFromDifferentAdGroups() {
        api.userSteps.adsSteps().shouldGetResultOnUnarchive(new IdsCriteriaMap()
                        .withIds(adId1, adId2),
                ExpectedResult.success(adId1), ExpectedResult.success(adId2));

        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId1, adId2))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE));
        List<StateEnum> states = response.getAds().stream().map(AdGetItem::getState).collect(toList());
        assumeThat("обяъвления разархивировались", states, contains(StateEnum.SUSPENDED, StateEnum.SUSPENDED));
    }
}
