package ru.yandex.autotests.direct.api.ads.unarchive;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersBannerType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.api5.ads.UnarchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by buhter on 28.07.17.
 */
@Aqua.Test
@Features(AdsFeatures.UNARCHIVE)
@Description("Объявление типа mcbanner не поддерживается")
@Issue("https://st.yandex-team.ru/DIRECT-66999")
public class UnArchiveMcbannerAdTest {
    private static final String LOGIN = AdsLogins.CLIENT;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createTestData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(1); //240x400
        Long campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign()
                                .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                        .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                                        .withSearch(new TextCampaignSearchStrategyAddMap().defaultHighestPosition()))));
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultTextImageAd(adGroupId, adImageHash);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);
        api.userSteps.adsSteps().adsArchive(adId);

        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.MCBANNER);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps()
                .setType(adGroupId, PhrasesAdgroupType.mcbanner);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).bannersSteps()
                .setBannersBannerType(adId, BannersBannerType.mcbanner);
    }

    @Test
    public void unArchiveMcbannerAd() {
        api.userSteps.adsSteps().shouldGetResultOnUnarchive(
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds(adId)),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.ADGROUP_NOT_SUPPORTED))
        );
    }
}
