package ru.yandex.autotests.direct.api.ads.unarchive;

import java.util.List;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.AdGetItem;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.general.StateEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.stream.Collectors.toList;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 16.04.15.
 * https://st.yandex-team.ru/TESTIRT-5211
 */
@Aqua.Test
@Features(AdsFeatures.UNARCHIVE)
@Description("Разархивация одного или нескольких баннеров")
@Issue("https://st.yandex-team.ru/DIRECT-34573")
@Tag(TagDictionary.TRUNK)
public class UnarchiveAdsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adId1;
    private Long adId2;

    @Before
    @Step("Подготовка данных для теста")
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdsLogins.CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdsLogins.CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        List<Long> adIds = api.userSteps.adsSteps().addDefaultTextAds(adGroupId, 2);
        adId1 = adIds.get(0);
        adId2 = adIds.get(1);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId1, adId2);
        api.userSteps.adsSteps().adsArchive(adId1, adId2);
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId1, adId2))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE));
        List<StateEnum> states = response.getAds().stream().map(AdGetItem::getState).collect(toList());
        assumeThat("баннеры заархивированы", states, contains(StateEnum.ARCHIVED, StateEnum.ARCHIVED));
    }

    @Test
    @Description("Разархивировать одно объявление")
    public void unarchiveOneAdTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnUnarchive(new IdsCriteriaMap().withIds(adId1), ExpectedResult.success());
        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId1))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE));
        StateEnum state = response.getAds().get(0).getState();
        assertThat("объявление разархивировалось", state, not(equalTo(StateEnum.ARCHIVED)));
    }

    @Test
    @Description("Разархивировать два объявления")
    public void unarchiveTwoAdsTest() {
        api.userSteps.adsSteps()
                .shouldGetResultOnUnarchive(new IdsCriteriaMap().withIds(adId1, adId2),
                        ExpectedResult.success(), ExpectedResult.success());

        GetResponse response = api.userSteps.adsSteps().adsGet(new GetRequestMap()
                .withSelectionCriteria(new AdsSelectionCriteriaMap().withIds(adId1, adId2))
                .withFieldNames(AdFieldEnum.ID, AdFieldEnum.STATE));
        List<StateEnum> states = response.getAds().stream().map(AdGetItem::getState).collect(toList());
        assertThat("объявления разархивировались", states, contains(StateEnum.SUSPENDED, StateEnum.SUSPENDED));
    }
}
