package ru.yandex.autotests.direct.api.ads.unarchive;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 03.02.16.
 * <p>
 * https://st.yandex-team.ru/TESTIRT-8412
 */
@Aqua.Test
@Features(AdsFeatures.UNARCHIVE)
@Issue("https://st.yandex-team.ru/DIRECT-50232")
@Description("Проверка статусов модерации рекламного объявления после разархивирования кампании")
@RunWith(Parameterized.class)
public class UnarchiveCampaignAdsStatusModerationTest {

    private static LogSteps log = LogSteps.getLogger(UnarchiveCampaignAdsStatusModerationTest.class);
    private static final String CLIENT = Logins.CLIENT_SELF;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter
    public BannersStatusmoderate statusModerateBefore;;

    @Parameterized.Parameter(value = 1)
    public BannersStatusmoderate statusModerateAfter;

    @Parameterized.Parameter(value = 2)
    public BannersStatuspostmoderate statusPostModerateBefore;

    @Parameterized.Parameter(value = 3)
    public BannersStatuspostmoderate statusPostModerateAfter;

    @Parameterized.Parameters(name = "statusModerateBefore = {0}, statusModerateAfter = {1}, " +
            "statusPostModerateBefore = {2}, statusPostModerateAfter = {3}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {
                        BannersStatusmoderate.Yes, BannersStatusmoderate.Yes,
                        BannersStatuspostmoderate.Yes, BannersStatuspostmoderate.Yes,
                },
                {
                        BannersStatusmoderate.Sending, BannersStatusmoderate.Ready,
                        BannersStatuspostmoderate.Yes, BannersStatuspostmoderate.No
                }
        });
    }

    private Long campaignId;
    private Long groupId;
    private Long adId;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        groupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.keywordsSteps().addDefaultKeyword(groupId);
        adId = api.userSteps.adsSteps().addDefaultTextAd(groupId);

        api.userSteps.campaignFakeSteps().makeCampaignStopped(campaignId);
        api.userSteps.campaignFakeSteps().setLastShowTimeAnHourAndMinuteAgo(campaignId);
        api.userSteps.campaignSteps().campaignsArchive(campaignId);
    }

    @Test
    public void unarchiveCampaignAdsStatusModeration() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT)
                .bannersSteps()
                .setBannerStatusModerate(adId, statusModerateBefore, statusPostModerateBefore);
        // DIRECT-81220
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT)
                .bannersSteps()
                .setBannersDomain(adId, "whitelistdomain.ru");

        api.userSteps.campaignSteps().campaignsUnarchive(campaignId);

        BannersRecord actualBanner = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT)
                .bannersSteps()
                .getBanner(adId);

        assertThat("данные изменились на ожидаемые", actualBanner.getStatusmoderate(),
                is(statusModerateAfter));
        assertThat("данные изменились на ожидаемые", actualBanner.getStatuspostmoderate(),
                is(statusPostModerateAfter));
    }
}
