package ru.yandex.autotests.direct.api.ads.unarchive;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdsFeatures.ARCHIVE)
@Description("Проверка недоступности кликовых объявлений с креативами в методе Ads.archive")
@Issue("https://st.yandex-team.ru/DIRECT-82657")
public class UnarchiveCpcAdVideoBuilderAdPositiveTest {

    private static final String LOGIN = AdsLogins.CLIENT;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void before() {
        Long creativeId = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(LOGIN).perfCreativesSteps().saveDefaultCpcVideoCreative(
                        Long.parseLong(User.get(LOGIN).getClientID()));
        api.as(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, LOGIN);
        adId = api.userSteps.adsSteps().addDefaultCpcVideoAdBuilderAd(adGroupId, creativeId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adId);

        api.userSteps.bannersFakeSteps().makeBannersStopped(adId);

        api.userSteps.adsSteps().adsArchive(LOGIN, adId);
    }

    @Test
    public void tryUnarchive() {
        api.userSteps.adsSteps().shouldGetResultOnUnarchive(new IdsCriteriaMap().withIds(adId),
                ExpectedResult.success());
    }
}
