package ru.yandex.autotests.direct.api.ads.update;

import java.util.Arrays;
import java.util.function.Supplier;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by zakhar on 10.03.16.
 * https://st.yandex-team.ru/TESTIRT-8657
 */

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка статуса StatusBsSynced у группы после обновления объявлением с {phrase_id} в href")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckAdGroupStatusBsSyncedOnUpdateAdWithPhraseIdInHrefTest {
    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long adGroupId;
    private long adId;

    @Parameter(0)
    public CampaignType campaignType;

    @Parameter(1)
    public AdGroupType adGroupType;

    @Parameter(2)
    public BannerType beforeBannerType;

    @Parameter(3)
    public Supplier<AdUpdateItemMap> adUpdateItemMapSupplier;

    @Parameters(name = "bannerType = {2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT,
                        (Supplier<AdUpdateItemMap>)() -> new AdUpdateItemMap().withTextAd(
                                new TextAdUpdateMap().withHref(TextAdAddMap.DEFAULT_HREF + "?{phraseid}"))},
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT,
                        (Supplier<AdUpdateItemMap>)() -> new AdUpdateItemMap().withMobileAppAd(
                                new MobileAppAdUpdateMap().withTrackingUrl(
                                        MobileAppAdAddMap.DEFAULT_TRACKING_URL + "?{phraseid}"))},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createObjects() {
        long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId = api.userSteps.adsSteps().addDefaultAd(adGroupId, beforeBannerType);

        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);
        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, Status.YES);

        GroupFakeInfo groupBeforeUpdate = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assumeThat("группе установился нужный статус синхронизации с БК",
                groupBeforeUpdate.getStatusBsSynced(), equalTo(Status.YES));
        assumeThat("у группы нужное значение has_phraseid_href",
                groupBeforeUpdate.getHasPhraseIdHref(), equalTo(Status.NO));
    }

    @Test
    public void adGroupStatusBsSyncedAfterAdd() {
        api.userSteps.adsSteps().adsUpdate(new UpdateRequestMap().withAds(
                adUpdateItemMapSupplier.get().withId(adId)));

        GroupFakeInfo groupBeforeUpdate = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("у группы изменилось значение has_phraseid_href",
                groupBeforeUpdate.getHasPhraseIdHref(), equalTo(Status.YES));
        assertThat("статус синхронизации группы с БК обновился",
                groupBeforeUpdate.getStatusBsSynced(), equalTo(Status.NO));
    }
}
