package ru.yandex.autotests.direct.api.ads.update;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 17.06.16.
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка статуса StatusBsSynced после привязки/отвязки картинки")
@Issue("https://st.yandex-team.ru/TESTIRT-9193")
@RunWith(Parameterized.class)
public class StatusBsSyncAfterUpdateAdImageHashTest {
    private static final String LOGIN = AdsLogins.CLIENT35;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adGroupId;
    private Long adId1;
    private Long adId2;

    @Parameter(0)
    public String description;

    @Parameter(1)
    public CampaignType campaignType;

    @Parameter(2)
    public AdGroupType groupType;

    @Parameter(3)
    public BannerType bannerType;

    @Parameter(4)
    public String oldAdImageHash;

    @Parameter(5)
    public String newAdImageHash;

    @Parameter(6)
    public String expectedGroupStatus;

    @Parameter(7)
    public String ad1AdImageHash;

    @Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        String[] adImageHashes = api.userSteps.imagesSteps().configLoginImages(LOGIN, ImageType.WIDE, 1, 2);
        String imageAdAdImageHash1 = api.userSteps.imagesStepsV5().addImageAdAdImage(5);
        String imageAdAdImageHash2 = api.userSteps.imagesStepsV5().addImageAdAdImage(6);
        return Arrays.asList(new Object[][]{
                {"Привязка картинки к динамическому объявлению",
                        CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC, null, adImageHashes[0], Status.NO, null},
                {"Изменение картинки в динамическом объявлении",
                        CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC, adImageHashes[0], adImageHashes[1], Status.YES, null},
                {"Отвязка картинки от динамического объявления",
                        CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC, adImageHashes[0], null, Status.YES, null},
                {"Привязка картинки к мобильному объявлению",
                        CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT, null, adImageHashes[0], Status.NO, null},
                {"Изменение картинки в мобильном объявлении",
                        CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT, adImageHashes[0], adImageHashes[1], Status.YES, null},
                {"Отвязка картинки от мобильного объявления",
                        CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT, adImageHashes[0], null, Status.YES, null},
                {"Изменение картинки в графическом объявлении",
                        CampaignType.TEXT, AdGroupType.BASE, BannerType.IMAGE_AD, imageAdAdImageHash1, imageAdAdImageHash2, Status.YES, imageAdAdImageHash1},
                {"Изменение картинки в графическом объявлении РМП",
                        CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.IMAGE_AD, imageAdAdImageHash1, imageAdAdImageHash2, Status.YES, imageAdAdImageHash1},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createObjects() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, groupType);
        adId1 = api.userSteps.adsSteps().addAdWithAdImageHash(adGroupId, groupType, bannerType, ad1AdImageHash);
        adId2 = api.userSteps.adsSteps().addAdWithAdImageHash(adGroupId, groupType, bannerType, oldAdImageHash);

        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId1, Status.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("объявлению установился нужный статус синхронизации с БК",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));

        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId2, Status.YES);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assumeThat("объявлению установился нужный статус синхронизации с БК",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));

        AdUpdateItemMap adUpdateItemMap = new AdUpdateItemMap().withId(adId2);
        switch (bannerType) {
            case DYNAMIC:
                api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);

                api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);

                api.userSteps.bannersFakeSteps().setStatusModerate(adId1, Status.YES);
                api.userSteps.bannersFakeSteps().setStatusModerate(adId2, Status.YES);

                adUpdateItemMap.withDynamicTextAd(
                        new DynamicTextAdUpdateMap().withAdImageHash(newAdImageHash)
                );
                break;

            case MOBILE_CONTENT:
                api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);

                api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);

                api.userSteps.bannersFakeSteps().setStatusModerate(adId1, Status.YES);
                api.userSteps.bannersFakeSteps().setStatusModerate(adId2, Status.YES);
                adUpdateItemMap.withMobileAppAd(
                        new MobileAppAdUpdateMap().withAdImageHash(newAdImageHash)
                );
                break;
            case IMAGE_AD:
                api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
                api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);
                /* иначе для ГО объявлений находящихся в New статус синхронизации с БК не сбросится */
                api.userSteps.bannersFakeSteps().setStatusModerate(adId1, Status.YES);
                api.userSteps.bannersFakeSteps().setStatusModerate(adId2, Status.YES);
                switch (groupType) {
                    case BASE:
                        adUpdateItemMap.withTextImageAd(
                                new TextImageAdUpdateMap().withAdImageHash(newAdImageHash)
                        );
                        break;
                    case MOBILE_CONTENT:
                        adUpdateItemMap.withMobileAppImageAd(
                                new MobileAppImageAdUpdateMap().withAdImageHash(newAdImageHash)
                        );
                        break;
                }
                break;
        }

        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(adUpdateItemMap),
                ExpectedResult.success(adId2)
        );
   }

    @Test
    public void firstAdStatusBsSyncedAfterUpdateSecondAd() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }

    @Test
    public void secondAdStatusBsSyncedAfterUpdate() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    public void adGroupStatusBsSyncedAfterUpdate() {
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                groupFakeInfo.getStatusBsSynced(), equalTo(expectedGroupStatus));
    }
}
