package ru.yandex.autotests.direct.api.ads.update;

import java.util.Arrays;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 04.05.16.
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка статуса StatusBsSynced после привязки/отвязки сайтлинков")
@Issue("https://st.yandex-team.ru/TESTIRT-9193")
@RunWith(Parameterized.class)
public class StatusBsSyncAfterUpdateSitelinkSetIdTest {
    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long adGroupId;
    private Long adId1;
    private Long adId2;

    @Parameter(0)
    public String description;

    @Parameter(1)
    public CampaignType campaignType;

    @Parameter(2)
    public AdGroupType groupType;

    @Parameter(3)
    public BannerType bannerType;

    @Parameter(4)
    public Long oldSitelinksSetId;

    @Parameter(5)
    public Long newSitelinksSetId;

    @Parameters(name = "{0}")
    public static Iterable<Object[]> data() {
        long sitelinkSetID = api.userSteps.sitelinksSteps().addDefaultSet(1);
        return Arrays.asList(new Object[][]{
                {"Привязка набора сайтлинков к динамическому объявлению",
                        CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC, null, sitelinkSetID},
                {"Отвязка набора сайтлинков от динамического объявления",
                        CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC, sitelinkSetID, null},
                {"Привязка набора сайтлинков к текстовому объявлению",
                        CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT, null, sitelinkSetID},
                {"Отвязка набора сайтлинков от текстового объявления",
                        CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT, sitelinkSetID, null}
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createObjects() {
        Long camapignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(camapignId, groupType);
        adId1 = api.userSteps.adsSteps().addDefaultAd(adGroupId, bannerType);
        if(groupType == AdGroupType.DYNAMIC) {
            api.userSteps.dynamicTextAdTargetsSteps().addDefaultWebpage(adGroupId);
            adId2 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                    .withAdGroupId(adGroupId)
                    .withDynamicTextAd(new DynamicTextAdAddMap()
                            .defaultDynamicTextAd()
                            .withSitelinkSetId(oldSitelinksSetId)));
        } else if(groupType == AdGroupType.BASE){
            api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
            adId2 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                    .withAdGroupId(adGroupId)
                    .withTextAd(new TextAdAddMap()
                            .defaultTextAd()
                            .withSitelinkSetId(oldSitelinksSetId)));
        }
        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, Status.YES);
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assumeThat("группе установился нужный статус синхронизации с БК",
                groupFakeInfo.getStatusBsSynced(), equalTo(Status.YES));

        api.userSteps.bannersFakeSteps().setStatusModerate(adId1, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId1, Status.YES);
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assumeThat("объявлению установился нужный статус синхронизации с БК",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));

        api.userSteps.bannersFakeSteps().setStatusModerate(adId2, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusBsSynced(adId2, Status.YES);
        bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assumeThat("объявлению установился нужный статус синхронизации с БК",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
        if(bannerType == BannerType.DYNAMIC){
            api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                            .withAds(new AdUpdateItemMap()
                                    .withId(adId2)
                                    .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                            .withSitelinkSetId(newSitelinksSetId))),
                    ExpectedResult.success(adId2));
        } else if (bannerType == BannerType.TEXT){
            api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                            .withAds(new AdUpdateItemMap()
                                    .withId(adId2)
                                    .withTextAd(new TextAdUpdateMap()
                                            .withSitelinkSetId(newSitelinksSetId))),
                    ExpectedResult.success(adId2));

        }
    }

    @Test
    public void firstAdStatusBsSyncedAfterUpdateSecondAd() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId1);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-55525")
    public void secondAdStatusBsSyncedAfterUpdate() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adId2);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                bannerFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    public void adGroupStatusBsSyncedAfterUpdate() {
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("значение StatusBsSynced соответствует ожидаемому",
                groupFakeInfo.getStatusBsSynced(), equalTo(Status.YES));
    }
}
