package ru.yandex.autotests.direct.api.ads.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPhoneflag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
@Features(AdsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-49087")
@Description("Изменение промодерированного объявления в группе без условий показа")
public class UpdateAdInAdGroupWithoutShowConditions {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule

    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter()
    public CampaignType campaignType;

    @Parameter(1)
    public AdGroupType adGroupType;

    @Parameter(2)
    public BannerType adType;

    @Parameter(3)
    public AdUpdateItemMap updateMap;

    @Parameter(4)
    public BannersStatusbssynced statusBsSynced;

    @Parameter(5)
    public BannersStatusmoderate statusModerate;

    @Parameter(6)
    public BannersStatuspostmoderate statusPostModerate;

    @Parameter(7)
    public BannersStatussitelinksmoderate statusSitelinksModerate;

    @Parameter(8)
    public BannersPhoneflag statusVCardMderate;

    private Long adId;
    private DirectJooqDbSteps directJooqDbSteps;

    @Parameters(name = "campaign type [{0}], group type [{1}], banner type [{2}]")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                // TODO: поправить кейс в DIRECT-121871
//                {CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT,
//                        new AdUpdateItemMap().withTextAd(new TextAdUpdateMap().withText("just for test")),
//                        BannersStatusbssynced.No, BannersStatusmoderate.Ready, BannersStatuspostmoderate.No,
//                        BannersStatussitelinksmoderate.New, BannersPhoneflag.New},
                {CampaignType.TEXT, AdGroupType.BASE, BannerType.IMAGE_AD,
                        new AdUpdateItemMap().withTextImageAd(
                                new TextImageAdUpdateMap().withHref("http://direct.yandex.ru")),
                        BannersStatusbssynced.No, BannersStatusmoderate.Ready, BannersStatuspostmoderate.No,
                        BannersStatussitelinksmoderate.Yes, BannersPhoneflag.Yes}, // NB: нет sitelink-ов и vcard-ов - не сбрасывается их статус модерации
                /*
                Поправить в DIRECT-122747
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT,
                        new AdUpdateItemMap().withMobileAppAd(new MobileAppAdUpdateMap().withTrackingUrl(null)),
                        BannersStatusbssynced.No, BannersStatusmoderate.Ready, BannersStatuspostmoderate.No, // NB: статусы модерации сбрасываются при изменении трекинговой ссылки
                        BannersStatussitelinksmoderate.Yes, BannersPhoneflag.Yes}, // NB: нет sitelink-ов и vcard-ов - не сбрасывается их статус модерации
                {CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.IMAGE_AD,
                        new AdUpdateItemMap().withMobileAppImageAd(
                                new MobileAppImageAdUpdateMap().withTrackingUrl(null)),
                        BannersStatusbssynced.No, BannersStatusmoderate.Ready, BannersStatuspostmoderate.No, // NB: статусы модерации сбрасываются при изменении трекинговой ссылки
                        BannersStatussitelinksmoderate.Yes, BannersPhoneflag.Yes}, // NB: нет sitelink-ов и vcard-ов - не сбрасывается их статус модерации
                */
                // TODO: поправить кейс в DIRECT-121871
//                {CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC,
//                        new AdUpdateItemMap().withDynamicTextAd(new DynamicTextAdUpdateMap().withText("just for test")),
//                        BannersStatusbssynced.No, BannersStatusmoderate.Ready, BannersStatuspostmoderate.No,
//                        BannersStatussitelinksmoderate.New, BannersPhoneflag.New}
                // NB: перфоманс кампании, группы и объявления пока не поддерживаются в АПИ
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);

        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(campaignType);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, adGroupType);
        adId = api.userSteps.addDefaultAdWithType(adGroupId, adGroupType, adType);

        api.userSteps.bannersFakeSteps().makeBannersActiveAndFullyModerated(adId);
        directJooqDbSteps.adGroupsSteps().makePhraseModeratedAndBsSynced(adGroupId);
        api.userSteps.campaignFakeSteps().makeCampaignActive(campaignId);
    }

    @Test
    @Description("Обновление промодерированного баннера в группе без условий показа")
    public void updateAdInAdGroupWithoutShowConditionsTest() {
        api.as(LOGIN).userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(updateMap.withId(adId)), ExpectedResult.success(adId));

        BannersRecord ad = directJooqDbSteps.bannersSteps().getBanner(adId);
        assumeThat("у баннера ожидаемое значение statusBsSynced", ad.getStatusbssynced(), equalTo(statusBsSynced));
        assumeThat("у баннера ожидаемое значение statusModerate", ad.getStatusmoderate(), equalTo(statusModerate));
        assumeThat("у баннера ожидаемое значение statusPostModerate", ad.getStatuspostmoderate(),
                equalTo(statusPostModerate));
        assumeThat("у баннера ожидаемое значение statusSitelinksModerate", ad.getStatussitelinksmoderate(),
                equalTo(statusSitelinksModerate));
        assumeThat("у баннера ожидаемое значение phoneflag", ad.getPhoneflag(), equalTo(statusVCardMderate));
    }
}
