package ru.yandex.autotests.direct.api.ads.update;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Запросы на обновление объвления с указанием нескольких типов")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
public class UpdateAdMoreThanOneTypeInOneRequestTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Обновить объявление, указав в запросе два типа: текстовое и рекламу мобильных приложений")
    public void textAndMobileAppTypes() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(666L)
                        .withMobileAppAd(new MobileAppAdUpdateMap()
                                .defaultMobileAppAd())
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd())),
                ExpectedResult.errors(
                        new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                "TextAd, DynamicTextAd, MobileAppAd, TextImageAd, MobileAppImageAd, TextAdBuilderAd, " +
                                        "MobileAppAdBuilderAd, CpmBannerAdBuilderAd, CpcVideoAdBuilderAd, " +
                                        "CpmVideoAdBuilderAd, ContentPromotionVideoAd, ContentPromotionCollectionAd, " +
                                        "ContentPromotionServiceAd, ContentPromotionEdaAd, SmartAdBuilderAd, " +
                                        "MobileAppCpcVideoAdBuilderAd")));
    }

    @Test
    @Description("Обновить объявление, указав в запросе три типа: текстовое , динамическое текстовое " +
            "и рекламу мобильных приложений")
    public void textAndDynamicTextMobileAppTypes() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(666L)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd())
                        .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                .defaultDynamicTextAd())
                        .withMobileAppAd(new MobileAppAdUpdateMap()
                                .defaultMobileAppAd())),
                ExpectedResult.errors(
                        new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                "TextAd, DynamicTextAd, MobileAppAd, TextImageAd, MobileAppImageAd, TextAdBuilderAd, " +
                                        "MobileAppAdBuilderAd, CpmBannerAdBuilderAd, CpcVideoAdBuilderAd, " +
                                        "CpmVideoAdBuilderAd, ContentPromotionVideoAd, ContentPromotionCollectionAd, " +
                                        "ContentPromotionServiceAd, ContentPromotionEdaAd, SmartAdBuilderAd, " +
                                        "MobileAppCpcVideoAdBuilderAd")));
    }

    @Test
    @Description("Обновить объявление, указав в запросе два типа: графическое и графическое РМП")
    public void textImageAdAndMobileAppImageAdTypes() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(new AdUpdateItemMap()
                        .withId(666L)
                        .withTextImageAd(new TextImageAdUpdateMap()
                                .withHref(""))
                        .withMobileAppImageAd(new MobileAppImageAdUpdateMap()
                                .withTrackingUrl(""))),
                ExpectedResult.errors(
                        new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                "TextAd, DynamicTextAd, MobileAppAd, TextImageAd, MobileAppImageAd, TextAdBuilderAd, " +
                                        "MobileAppAdBuilderAd, CpmBannerAdBuilderAd, CpcVideoAdBuilderAd, " +
                                        "CpmVideoAdBuilderAd, ContentPromotionVideoAd, ContentPromotionCollectionAd, " +
                                        "ContentPromotionServiceAd, ContentPromotionEdaAd, SmartAdBuilderAd, " +
                                        "MobileAppCpcVideoAdBuilderAd")));
    }
}
