package ru.yandex.autotests.direct.api.ads.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.cmd.rules.CreativeBannerRule;
import ru.yandex.autotests.direct.cmd.rules.DirectCmdRule;
import ru.yandex.autotests.direct.utils.campaigns.CampaignTypeEnum;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.AdGroupType;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.junit.runners.Parameterized.Parameters;

/**
 * Created by pavryabov on 20.09.16.
 * https://st.yandex-team.ru/TESTIRT-10249
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка недоступности ГО объявлений с креативами в методе Ads.update")
@Issue("https://st.yandex-team.ru/DIRECT-56944")
@RunWith(Parameterized.class)
public class UpdateAdWithCreativeTest {
    //DIRECT-58635

    private final static String CLIENT = AdsLogins.CLIENT48;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @ClassRule
    public static DirectCmdRule defaultClassRule = DirectCmdRule.defaultClassRule();

    public CreativeBannerRule bannersRule;

    @Rule
    public DirectCmdRule cmdRule;

    private Long bidWithCreative;

    public AdGroupType adGroupType;

    @Parameters(name = "CampaignType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignTypeEnum.TEXT, AdGroupType.BASE},
                {CampaignTypeEnum.MOBILE, AdGroupType.MOBILE_CONTENT}
        };
        return Arrays.asList(data);
    }

    public UpdateAdWithCreativeTest(CampaignTypeEnum campaignTypeEnum, AdGroupType adGroupType) {
        this.adGroupType = adGroupType;
        bannersRule = new CreativeBannerRule(campaignTypeEnum).withUlogin(CLIENT);
        cmdRule = DirectCmdRule.defaultRule().withRules(bannersRule);
    }

    @Before
    public void before() {
        bidWithCreative = bannersRule.getBannerId();
    }

    @Test
    public void tryUpdate() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(bidWithCreative)
                                .withTextAd(new TextAdUpdateMap().defaultAd())),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.WRONG_AD_TYPE)));
    }
}
