package ru.yandex.autotests.direct.api.ads.update;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 31.08.15.
 * https://st.yandex-team.ru/TESTIRT-6853
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Попытка обновить объявление с несоответствующим типом")
@Issue("https://st.yandex-team.ru/DIRECT-44779")
public class UpdateAdWrongType {

    private static final String LOGIN = AdsLogins.CLIENT45;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
    }

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    @Description("Попытка обновить объявление с рекламой мобильного приложения как текстовое")
    public void updateMobileAppAd() {
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.mobile_content);
        long adId = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupId);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd())),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.WRONG_AD_TYPE)));
    }

    @Test
    @Description("Попытка обновить динамическое текстовое объявление приложения как текстовое")
    public void updateDynamicTextAd() {
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        jooqDbSteps.adGroupsSteps().setType(adGroupId, PhrasesAdgroupType.dynamic);
        long adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd())),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.WRONG_AD_TYPE)));
    }

    @Test
    @Description("Попытка обновить текстовое объявление как динамическое текстовое")
    public void updateTextAd() {
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                        .defaultDynamicTextAd())),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.WRONG_AD_TYPE)));
    }

    @Test
    @Description("Попытка обновить графическое текстовое объявление как графическое РМП")
    public void updateTextImageAdAsMobileAppImageAd() {
        String adImageHash = api.userSteps.imagesStepsV5().addImageAdAdImage(6);
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        long adId = api.userSteps.adsSteps().addDefaultTextImageAd(adGroupId, adImageHash);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withMobileAppImageAd(new MobileAppImageAdUpdateMap())),
                JavaOrPerlExpectedResult.expect(6000,
                        Api5ErrorDetails.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP,
                        Api5ErrorDetailsJava.TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP_EN));
    }

    @Test
    @Description("Попытка обновить текстовое объявление как графическое текстовое")
    public void updateTextImageAdAsTextAd() {
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);

        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adId)
                                .withTextImageAd(new TextImageAdUpdateMap())),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.WRONG_AD_TYPE)));
    }
}
