package ru.yandex.autotests.direct.api.ads.update;

import java.util.Arrays;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdGetItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.ads.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdGetMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by proxeter on 14.01.16
 *
 * https://st.yandex-team.ru/TESTIRT-7903
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-48365")
@Features(AdsFeatures.UPDATE)
@Description("Проверка корректности сохранения данных при обновлении объявлений в обратном порядке")
public class UpdateAdsInReverseOrderTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID1;
    private static long adID2;

    private static long adGroupId1;
    private static long adGroupId2;

    private static String textForAd1 = RandomStringUtils.randomAlphabetic(8);
    private static String textForAd2 = RandomStringUtils.randomAlphabetic(8);

    private static String titleForAd1 = RandomStringUtils.randomAlphabetic(8);
    private static String titleForAd2 = RandomStringUtils.randomAlphabetic(8);

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignID);
        adGroupId2 = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignID);

        adID1 = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withMobileAppAd(
                                new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withTitle(titleForAd1)
                                        .withText(RandomStringUtils.randomAlphabetic(8))
                        )
                        .withAdGroupId(adGroupId1),
                LOGIN
        );

        adID2 = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withMobileAppAd(
                                new MobileAppAdAddMap()
                                        .defaultMobileAppAd()
                                        .withTitle(titleForAd2)
                                        .withText(RandomStringUtils.randomAlphabetic(8))
                        )
                        .withAdGroupId(adGroupId2),
                LOGIN
        );
    }

    @Test
    public void updateAdsInReverseOrder() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                    new AdUpdateItemMap()
                            .withId(adID2)
                            .withMobileAppAd(new MobileAppAdUpdateMap().withText(textForAd2)),
                    new AdUpdateItemMap()
                            .withId(adID1)
                            .withMobileAppAd(new MobileAppAdUpdateMap().withText(textForAd1))
                ),
                ExpectedResult.success(adID2),
                ExpectedResult.success(adID1)
        );

        GetResponse response = api.userSteps.adsSteps().adsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdsSelectionCriteriaMap().withIds(adID1, adID2))
                        .withFieldNames(AdFieldEnum.ID, AdFieldEnum.AD_GROUP_ID)
                        .withMobileAppAdFieldNames(MobileAppAdFieldEnum.TEXT, MobileAppAdFieldEnum.TITLE)
        );

        assertThat("объявления обновились правильно", response.getAds(), beanDifferV5(Arrays.asList(
                new AdGetItemMap()
                        .withId(adID1)
                        .withAdGroupId(adGroupId1)
                        .withMobileAppAd(new MobileAppAdGetMap().withText(textForAd1).withTitle(titleForAd1))
                        .getBean(),
                new AdGetItemMap()
                        .withId(adID2)
                        .withAdGroupId(adGroupId2)
                        .withMobileAppAd(new MobileAppAdGetMap().withText(textForAd2).withTitle(titleForAd2))
                        .getBean()))
        );
    }
}
