package ru.yandex.autotests.direct.api.ads.update;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.MobileAppAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 01.12.15.
 * https://st.yandex-team.ru/TESTIRT-7862
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидного обновления объявлений разных типов в одном запросе")
@Issue("https://st.yandex-team.ru/DIRECT-43825")
public class UpdateAdsOfDifferentTypesInOneRequestTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    private static final String NEW_TEXT = "SUPER_NEW_TEXT";

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static int shard;

    @BeforeClass
    public static void prepareStaticData() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
    }

    private long textAdId;
    private long dynamicTextAdId;
    private long mobileAppAdId;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long textCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long textAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(textCampaignId);
        textAdId = api.userSteps.adsSteps().addDefaultTextAd(textAdGroupId);

        Long dynamicTextCampaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long dynamicTextAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(dynamicTextCampaignId);
        dynamicTextAdId = api.userSteps.adsSteps().addDefaultDynamicTextAd(dynamicTextAdGroupId);

        Long mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        Long mobileAppAdGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(mobileAppCampaignId);
        mobileAppAdId = api.userSteps.adsSteps().addDefaultMobileAppAd(mobileAppAdGroupId);
    }


    @Test
    @Description("Обновить динамическое текстовое объявление и текстовое за один запрос")
    public void updateDynamicTextAdAndTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap()
                        .withId(dynamicTextAdId)
                        .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                .defaultDynamicTextAd()
                                .withText(NEW_TEXT)),
                new AdUpdateItemMap()
                        .withId(textAdId)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd()
                                .withText(NEW_TEXT))),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    @Description("Обновить объявление с рекламой мобильных приложений и текстовое за один запрос")
    public void updateMobileAppAdAndTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap()
                        .withId(mobileAppAdId)
                        .withMobileAppAd(new MobileAppAdUpdateMap()
                                .defaultMobileAppAd()
                                .withText(NEW_TEXT)),
                new AdUpdateItemMap()
                        .withId(textAdId)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd()
                                .withText(NEW_TEXT))),
                ExpectedResult.success(), ExpectedResult.success());
    }

    @Test
    @Description("Обновить текстовое, динамическое текстовое объявление и текстовое за один запрос")
    public void updateTextAndDynamicTextAdAndTextAd() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap()
                        .withId(textAdId)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd()
                                .withText(NEW_TEXT)),
                new AdUpdateItemMap()
                        .withId(dynamicTextAdId)
                        .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                .defaultDynamicTextAd()
                                .withText(NEW_TEXT)),
                new AdUpdateItemMap()
                        .withId(mobileAppAdId)
                        .withMobileAppAd(new MobileAppAdUpdateMap()
                                .defaultMobileAppAd()
                                .withText(NEW_TEXT))),
                ExpectedResult.success(), ExpectedResult.success(), ExpectedResult.success());
    }
}
