package ru.yandex.autotests.direct.api.ads.update;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.junit.runners.Parameterized.Parameter;
import static org.junit.runners.Parameterized.Parameters;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.Common.fieldMustBePositiveInteger;
import static ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult.expect;

/**
 * Created by semkagtn on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Неверные идентификаторы в запросе на обновление текстового объявления")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class UpdateInvalidIdTest {

    private static final String LOGIN = AdsLogins.CLIENT;
    private static final String ANOTHER_LOGIN = AdsLogins.CLIENT_ELSE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameter(0)
    public String description;

    @Parameter(1)
    public long invalidAdID;

    @Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(ANOTHER_LOGIN);

        api.as(ANOTHER_LOGIN);
        long anotherCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        long anotherAdGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignID);
        long anotherAdID = api.userSteps.adsSteps().addDefaultTextAd(anotherAdGroupID);

        api.as(LOGIN);
        long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        long adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        long nonexistentAdID = adID + 500000;
        long deletedAdID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        api.userSteps.adsSteps().adsDelete(deletedAdID);

        long archivedAdID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        api.userSteps.bannersFakeSteps().makeBannersModerated(archivedAdID);
        api.userSteps.adsSteps().adsArchive(archivedAdID);

        long archivedCampaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        long archivedAdGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(archivedCampaignID);
        long adIdFromArchivedCampaign = api.userSteps.adsSteps().addDefaultTextAd(archivedAdGroupID);
        api.userSteps.campaignSteps().campaignsSuspend(archivedCampaignID);
        api.userSteps.campaignSteps().campaignsArchive(archivedCampaignID);

        return Arrays.asList(new Object[][]{
                {"идентификатор архивированного объявления", archivedAdID,
                        expect(8300,
                                Api5ErrorDetails.CANT_UPDATE_ARCHIVED_AD,
                                Api5ErrorDetailsJava.CANT_UPDATE_ARCHIVED_AD)},
                {"идентификатор объявления из архивированной кампании", adIdFromArchivedCampaign,
                        expect(8300,
                                Api5ErrorDetails.CANT_UPDATE_AD_IN_ARCHIVED_CAMPAIGN,
                                Api5ErrorDetailsJava.CANT_UPDATE_AD_IN_ARCHIVED_CAMPAIGN)},
                {"несуществующий идентификатор объявления", nonexistentAdID, adNotFound()},
                {"удалённый идентификатор объявления", deletedAdID, adNotFound()},
                {"чужой идентификатор объявления", anotherAdID, adNotFound()},
                {"нулевой идентификатор объявления", 0,
                        fieldMustBePositiveInteger(capitalize(AdUpdateItemMap.ID))},
                {"отрицательный идентификатор объявления", -1,
                        fieldMustBePositiveInteger(capitalize(AdUpdateItemMap.ID))},
        });
    }

    private static JavaOrPerlExpectedResult adNotFound() {
        return expect(8800, Api5ErrorDetails.AD_NOT_FOUND, Api5ErrorDetailsJava.AD_NOT_FOUND);
    }

    @Before
    public void addUnitsToUser() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void updateInvalidAd() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(invalidAdID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd())),
                expectedResult);
    }
}
