package ru.yandex.autotests.direct.api.ads.update;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка возвращения пообъектных ошибках при обновлении объявлений")
@Tag(TagDictionary.TRUNK)
public class UpdateMultipleErrorTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID;

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
    }

    @Test
    @Description("Валидный и невалидный объекты в запросе на обновление объявлений")
    public void validAndInvalidObjectsInRequest() {
        long nonexistentAdID = adID + 500000;
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap()
                        .withId(adID)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd()),
                new AdUpdateItemMap()
                        .withId(nonexistentAdID)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd())),
                ExpectedResult.success(adID),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)));
    }

    @Test
    @Description("Невалидный и валидный объекты в запросе на обновление объявлений")
    public void invalidAndValidObjectsInRequest() {
        long nonexistentAdID = adID + 500000;
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(
                        new AdUpdateItemMap()
                                .withId(nonexistentAdID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd()),
                        new AdUpdateItemMap()
                                .withId(adID)
                                .withTextAd(new TextAdUpdateMap()
                                        .defaultAd())),
                ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.AD_NOT_FOUND)),
                ExpectedResult.success(adID));
    }
}
