package ru.yandex.autotests.direct.api.ads.update;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by semkagtn on 13.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Одинаковые идентификаторы в запросе на обновление объявлений")
@Tag(TagDictionary.TRUNK)
public class UpdateSameIdsTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID;

    @Before
    @Step("Подготовка данных для теста")
    public void createAd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(LOGIN);
        long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        adID = api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
    }

    @Test
    public void sameIdsInRequest() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withAds(
                new AdUpdateItemMap()
                        .withId(adID)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd()),
                new AdUpdateItemMap()
                        .withId(adID)
                        .withTextAd(new TextAdUpdateMap()
                                .defaultAd())),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)))
                        .perl(ExpectedResult.errors(new Notification(9800))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)))
                        .perl(ExpectedResult.errors(new Notification(9800))));
    }
}
