package ru.yandex.autotests.direct.api.ads.update;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;

/**
 * Created by semkagtn on 14.04.15.
 * https://st.yandex-team.ru/TESTIRT-5113
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Обновление слишком большого числа объявлений за один запрос")
@Tag(TagDictionary.TRUNK)
public class UpdateTooMuchAdsTest {

    private static final String LOGIN = AdsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void addUnitsToClient() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
    }

    @Test
    public void updateTooMuchAds() {
        AdUpdateItemMap[] adUpdateItemMaps = new AdUpdateItemMap[AdUpdateItemMap.MAX_ADS_AMOUNT + 1];
        Arrays.fill(adUpdateItemMaps, new AdUpdateItemMap()
                .withTextAd(new TextAdUpdateMap()
                        .defaultAd()));

        api.userSteps.adsSteps().expectErrorOnAdsUpdate(
                new UpdateRequestMap().withAds(adUpdateItemMaps),
                new Api5Error(9300, Api5ErrorDetails.MAX_UPDATE_ADS_LIMIT_EXCEEDED, AdUpdateItemMap.MAX_ADS_AMOUNT));
    }
}
