package ru.yandex.autotests.direct.api.ads.update.cpcvideoadbuilderad;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpcVideoAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка работы поля CreativeId. Позитивные сценарии.")
@Issue("https://st.yandex-team.ru/DIRECT-82654")
public class UpdateCpcVideoBuilderAdCreativeValidationPositiveTest {
    private static String CLIENT = AdsLogins.CLIENT;
    private static Long adId;
    private static Long creativeId2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest(){
        Long clientId = Long.parseLong(User.get(CLIENT).getClientID());
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long creativeId1 = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCpcVideoCreative(clientId);
        creativeId2 = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCpcVideoCreative(clientId);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultCpcVideoAdBuilderAd(adGroupId, creativeId1);

    }

    @Test
    public void updateCpcVideoBuilderAd() {

        api.as(CLIENT).userSteps.adsSteps().adsUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap()
                                .withCpcVideoAdBuilderAd(
                                        new CpcVideoAdBuilderAdUpdateMap()
                                                .withCreative(creativeId2))
                                .withId(adId)
                )
        );
        List<Long> creativeIds = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT)
                .bannersPerformanceSteps().findCreativeIds(adId);
        assumeThat("получена одна запись", creativeIds, hasSize(1));
        assertThat("получена ожидаемая связка из banner_performance", creativeIds.get(0), equalTo(creativeId2));
    }
}
