package ru.yandex.autotests.direct.api.ads.update.cpcvideoadbuilderad;

import java.util.Collection;

import org.glassfish.gmbal.Description;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsHrefValidationHelper;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpcVideoAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации поля Href в видео-объявлении. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-82654")
@RunWith(Parameterized.class)
public class UpdateCpcVideoBuilderAdHrefValidationNegativeTest {
    private static String CLIENT = AdsLogins.CLIENT39;
    private static Long creativeId;
    private static Long adGroupId;
    private static Long adId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String href;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    // Вопрос для ревью: тест UpdateTextAdBuilderAdHrefValidationNegativeTest, который использует те же
    // getHrefDataForNegativeParameterized, падает на последней проверке. Мне не понятно почему.
    // Текущий тест тоже падает ровно на той же проверке. Вопрос - что делать?
    public static Collection<Object[]> data() {
        return AdsHrefValidationHelper.getHrefDataForNegativeParameterized();
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        creativeId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).perfCreativesSteps()
                .saveDefaultCpcVideoCreative(Long.parseLong(User.get(CLIENT).getClientID()));

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultCpcVideoAdBuilderAd(adGroupId, creativeId);

    }

    @Test
    public void updateWithHref() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withCpcVideoAdBuilderAd(new CpcVideoAdBuilderAdUpdateMap()
                                        .withHref(href))
                                .withId(adId)),
                expectedResult);
    }
}
