package ru.yandex.autotests.direct.api.ads.update.cpmbanneradbuilderad;

import java.util.Arrays;
import java.util.Collection;

import org.glassfish.gmbal.Description;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка валидации типа креатива (creative_type из ppc.perf_creatives)")
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@RunWith(Parameterized.class)
public class UpdateCpmBannerAdBuilderAdCreativeTypeTest {

    private static String LOGIN = AdsLogins.CLIENT;
    private Long adId;
    private static Long adGroupId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps dbSteps =
            api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(LOGIN);

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public Long creativeIdForAdd;

    @Parameterized.Parameter(2)
    public Long creativeIdForUpdate;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Long videoCreativeId = dbSteps.perfCreativesSteps().saveDefaultVideoCreative(
                Long.parseLong(User.get(LOGIN).getClientID()), 1L);
        Long performanceCreativeId = dbSteps.perfCreativesSteps().saveDefaultPerfCreative(
                Long.parseLong(User.get(LOGIN).getClientID()));
        Long canvasCreativeId = dbSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(LOGIN).getClientID()));
        Long html5CreativeId = dbSteps.perfCreativesSteps().saveDefaultHtml5CreativesForClient(
                Long.parseLong(User.get(LOGIN).getClientID()));

        Object[][] data = new Object[][]{
                {"creative_type = video_addition", canvasCreativeId, videoCreativeId,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CREATIVE_NOT_FOUND))},
                {"creative_type = performance", canvasCreativeId, performanceCreativeId,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CREATIVE_NOT_FOUND))},
                {"creative_type = canvas", html5CreativeId, canvasCreativeId,
                        ExpectedResult.success()},
                {"creative_type = html5", canvasCreativeId, html5CreativeId,
                        ExpectedResult.success()}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void addCampaignAndAdGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(campaignId);
    }

    @Before
    public void addAd() {
        adId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(adGroupId, creativeIdForAdd);
    }

    @Test
    public void updateCpmBannerAdBuilderAdWithOtherCreativeType() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAds(
                        new AdUpdateItemMap()
                                .withCpmBannerAdBuilderAd(
                                        new CpmBannerAdBuilderAdUpdateMap().withCreative(creativeIdForUpdate))
                                .withId(adId)),
                expectedResult
        );
    }
}
