package ru.yandex.autotests.direct.api.ads.update.cpmbanneradbuilderad;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerTurbolandingsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.CampaignsType;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.CpmBannerAdBuilderAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static com.google.common.primitives.Longs.asList;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by adubinkin on 08.04.19.
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Общие проверки поля обновления поля TurboPageId")
@Issue("https://st.yandex-team.ru/DIRECT-85612")
public class UpdateCpmBannerAdTurboPageIdTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adId;
    private static Long turboPageId;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String client = AdsLogins.CLIENT;
    private static DirectJooqDbSteps jooqSteps;

    @BeforeClass
    public static void initTest() {
        jooqSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client);
        Long clientId = jooqSteps.usersSteps().getUser(client).getClientid();

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setType(campaignId, CampaignsType.CPM_BANNER);
        Long creativeId = jooqSteps.perfCreativesSteps().saveDefaultCanvasCreativesForClient(
                Long.parseLong(User.get(client).getClientID()));
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerKeywordsAdGroup(campaignId);
        adId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(adGroupId, creativeId);

        turboPageId = jooqSteps.turboLandingsSteps().createDefaultTurbolanding(clientId);
    }

    @AfterClass
    public static void deleteTurboPages() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).turboLandingsSteps()
                .deleteTurboLandings(asList(turboPageId));
    }


    @Test
    public void checkInDbAfterUpdate() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(AdsLogins.CLIENT);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(
                                new AdUpdateItemMap().withCpmBannerAdBuilderAd(
                                        new CpmBannerAdBuilderAdUpdateMap().withTurboPageId(turboPageId)
                                ).withId(adId)
                ),
                ExpectedResult.success());

        BannerTurbolandingsRecord bannerTurbolandingsRecord = jooqSteps.bannerTurbolandingsSteps().getBannerTurbolandings(adId).get(0);
        assertThat("поле turboPageId верно записалось в базу", bannerTurbolandingsRecord.getTlId(), beanDiffer(turboPageId));
    }
}
