package ru.yandex.autotests.direct.api.ads.update.dynamictextad;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.ads.AdsFeatures;
import ru.yandex.autotests.direct.api.ads.AdsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesFormatsImageType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.common.api45.AdImage;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.DynamicTextAdUpdateMap;
import ru.yandex.autotests.directapi.model.api5.ads.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 04.04.16.
 * https://st.yandex-team.ru/TESTIRT-8934
 */
@Aqua.Test
@Features(AdsFeatures.UPDATE)
@Description("Проверка обновления объявления со старой маленькой картинкой")
@Issue("https://st.yandex-team.ru/DIRECT-49672")
public class UpdateAdWithOldSmallImageTest {
    private static final String LOGIN = AdsLogins.CLIENT30;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long adGroupId;
    private static String smallAdImageHash;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static long adID1;
    private Long adID2;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        Long campaignID = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignID);

        AdImage adImage = api.userSteps.imagesSteps()
                .uploadRawImage("star", "https://direct-qa.s3.mds.yandex.net/images/star600x450.jpg", LOGIN);
        smallAdImageHash = adImage.getAdImageHash();
        adID1 = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                .withAdGroupId(adGroupId)
                .withDynamicTextAd(new DynamicTextAdAddMap()
                        .defaultDynamicTextAd()
                        .withAdImageHash(smallAdImageHash)));

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN)
                .imagesSteps().setImageType(smallAdImageHash, BannerImagesFormatsImageType.small);
    }

    @Test
    public void updateAdWithOldSmallAdImage() {
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID1)
                                .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                        .withText("C картинкой " + smallAdImageHash))),
                ExpectedResult.success(adID1));
    }

    @Test
    public void tryAddSmallImageByUpdate() {
        adID2 = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
        api.userSteps.adsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAds(new AdUpdateItemMap()
                                .withId(adID2)
                                .withDynamicTextAd(new DynamicTextAdUpdateMap()
                                        .withAdImageHash(smallAdImageHash))),
                ExpectedResult.errors(new Notification(6000, Api5ErrorDetails.INVALID_AD_IMAGE_TYPE_FOR_THIS_BANNER)));
    }

    @AfterClass
    public static void removeSmallImage() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN)
                .imagesSteps().deleteBannerImagesFormatsRecord(smallAdImageHash);
    }
}
